"use strict";

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

(function () {
  "use strict";

  angular.module("webpub:data", []).provider("DataService", function () {
    function _class() {
      _classCallCheck(this, _class);
    }

    _createClass(_class, [{
      key: "$get",
      value: function $get() {
        return {
          webpub: webpub //externalized webpub variable
        };
      }
    }]);

    return _class;
  }());
  angular.module("webpub:config", []).provider("ConfigService", function () {
    function _class2() {
      _classCallCheck(this, _class2);
    } // externalized config variable


    _createClass(_class2, [{
      key: "$get",
      value: function $get() {
        return config;
      }
    }]);

    return _class2;
  }());
  angular.module("webpub:additional-pages", []).provider("AdditionalPagesService", function () {
    function _class3() {
      _classCallCheck(this, _class3);
    } // externalized config variable


    _createClass(_class3, [{
      key: "$get",
      value: function $get() {
        return additionalPages;
      }
    }]);

    return _class3;
  }());

  angular.module("webpub", [
  // Start: Misc. Dependencies
  "ngRoute", "ngAnimate", "ui.router", "ui.tree", "ui.bootstrap", "ui.select", "angular.filter", "dibari.angular-ellipsis", "growlNotifications", "angularMoment", "angular-jwt", "webpub:data", "webpub:config", "webpub:additional-pages"]).config(["$stateProvider", "$locationProvider", "$urlRouterProvider", "DataServiceProvider", "AdditionalPagesServiceProvider", function ($stateProvider, $locationProvider, $urlRouterProvider, DataServiceProvider, AdditionalPagesServiceProvider) {
    $locationProvider.html5Mode(false);

    $urlRouterProvider.otherwise("/");

    var webpubData = DataServiceProvider.$get().webpub.data;

    function jwtGuard($state, jwt, $timeout, ConfigService) {
      var authEnabled = ConfigService.services && ConfigService.services.authEnabled;

      if (authEnabled && !jwt) {
        $timeout(function () {
          return $state.go("login", null);
        });
      }
    }

    $stateProvider.state("empty", {
      url: "",
      controller: function controller($state) {
        return $state.go("home");
      }
    }).state("index", {
      url: "/",
      controller: function controller($state) {
        return $state.go("home");
      }
    }).state("home", {
      url: "/home",
      templateProvider: function templateProvider(TemplateService) {
        return TemplateService.getIframeTemplate();
      },
      controller: "extraPageController",
      controllerAs: "$ctrl",
      resolve: {
        jwt: function jwt(LoginService, $stateParams) {
          return LoginService.checkAndResolveJWT("home", $stateParams);
        },
        pageName: function pageName($stateParams) {
          return "home";
        },
        location: function location($stateParams) {
          return "content/start.html";
        },
        pages: function pages() {
          return [];
        }
      },
      onEnter: jwtGuard
    }).state("toc", {
      url: "/toc/:index",
      templateProvider: function templateProvider(TemplateService) {
        return TemplateService.getToc();
      },
      controller: "tocController",
      controllerAs: "$ctrl",
      resolve: {
        jwt: function jwt(LoginService, $stateParams) {
          return LoginService.checkAndResolveJWT("toc", $stateParams);
        },
        conference: function conference($stateParams) {
          return webpubData.conferences[$stateParams.index];
        }
      },
      onEnter: jwtGuard
    }).state("author-index", {
      url: "/author-index",
      templateProvider: function templateProvider(TemplateService) {
        return TemplateService.getAuthorIndex();
      },
      controller: "authorIndexController",
      controllerAs: "$ctrl",
      resolve: {
        jwt: function jwt(LoginService, $stateParams) {
          return LoginService.checkAndResolveJWT("author-index", $stateParams);
        },
        authors: function authors() {
          return webpubData.authors;
        }
      },
      onEnter: jwtGuard
    }).state("affiliation-index", {
      url: "/affiliation-index",
      templateProvider: function templateProvider(TemplateService) {
        return TemplateService.getAffiliationIndex();
      },
      controller: "affiliationIndexController",
      controllerAs: "$ctrl",
      resolve: {
        jwt: function jwt(LoginService, $stateParams) {
          return LoginService.checkAndResolveJWT("affiliation-index", $stateParams);
        },
        affiliations: function affiliations() {
          return webpubData.affiliations;
        }
      },
      onEnter: jwtGuard
    }).state("search", {
      url: "/search",
      templateProvider: function templateProvider(TemplateService) {
        return TemplateService.getSearch();
      },
      controller: "searchController",
      controllerAs: "$ctrl",
      resolve: {
        jwt: function jwt(LoginService, $stateParams) {
          return LoginService.checkAndResolveJWT("search", $stateParams);
        },
        conferences: function conferences() {
          return webpubData.conferences;
        }
      },
      onEnter: jwtGuard
    }).state("login", {
      url: "/login",
      templateProvider: function templateProvider(TemplateService) {
        return TemplateService.getLogin();
      },
      controller: "loginController",
      controllerAs: "$ctrl"
    }).state("extra-page", {
      params: {
        pageName: null,
        location: null
      },
      url: "/pages/:pageName",
      templateProvider: function templateProvider(TemplateService) {
        return TemplateService.getIframeTemplate();
      },
      controller: "extraPageController",
      controllerAs: "$ctrl",
      resolve: {
        jwt: function jwt(LoginService, $stateParams) {
          return LoginService.checkAndResolveJWT("extra-page", $stateParams);
        },
        pageName: function pageName($stateParams) {
          return $stateParams.pageName;
        },
        location: function location($stateParams) {
          return $stateParams.location;
        },
        pages: function pages() {
          return AdditionalPagesServiceProvider;
        }
      },
      onEnter: jwtGuard
    });
  }]).run(["$rootScope", function ($rootScope) {
    $rootScope.$on("$stateChangeError", console.log.bind(console));
  }])
  // GDPR
  .run(["$window", "ConfigService", function ($window, ConfigService) {
    if (ConfigService.enableGDPR) {
      $window.cookieconsent.initialise(json);
    }
  }]);
})();
"use strict";

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

(function () {
  "use strict";

  angular.module("webpub").controller("affiliationIndexController", function () {
    function affiliationIndexController(affiliations, FileService, $anchorScroll, $location, jwt) {
      _classCallCheck(this, affiliationIndexController);

      this.affiliations = affiliations;
      this.FileService = FileService;
      this.$anchorScroll = $anchorScroll;
      this.$location = $location;
      this.jwt = jwt;
    }

    _createClass(affiliationIndexController, [{
      key: "affiliationStartsWithLetter",
      value: function affiliationStartsWithLetter(affiliation, letter) {
        if (letter === "#") {
          // get alphabet letters
          var alphabet = _.tail(this.alphabet);

          // If there is no match for any alphabet letter then consider this a digit
          return !_.some(alphabet, function (nextLetter) {
            return affiliation.slice(0, 1).localeCompare(nextLetter, "en", {
              usage: "search",
              sensitivity: "base",
              ignorePunctuation: true
            }) === 0;
          });
        } else {
          // check if the string matches the current letter
          return affiliation.slice(0, 1).localeCompare(letter, "en", {
            usage: "search",
            sensitivity: "base",
            ignorePunctuation: true
          }) === 0;
        }
      }
    }, {
      key: "$onInit",
      value: function $onInit() {
        var _this = this;

        this.alphabet = "#ABCDEFGHIJKLMNOPQRSTUVWXYZ".split("");
        var startIdx = 0;
        this.affiliationMap = this.alphabet.reduce(function (affiliationMap, letter) {
          // get the cutoff index
          // this is the start index of the next affiliations
          // the affiliations under the final alphabet listing with have cutoff = -1
          var cutOff = _this.affiliations.findIndex(function (a, idx) {
            return idx >= startIdx && !_this.affiliationStartsWithLetter(a.affiliation, letter);
          });

          if (cutOff >= 0) {
            // console.log(
            //   letter,
            //   startIdx,
            //   cutOff,
            //   this.affiliations.slice(startIdx, cutOff)
            // );
            affiliationMap[letter] = _this.affiliations.slice(startIdx, cutOff);
            startIdx = cutOff;
          }

          // handle the final affiliations
          else {
              // console.log(
              //   letter,
              //   startIdx,
              //   cutOff,
              //   this.affiliations.slice(startIdx)
              // );
              affiliationMap[letter] = _this.affiliations.slice(startIdx);
            }
          return affiliationMap;
        }, {});
        // console.log("affiliationMap: ", this.affiliationMap);
      }
    }, {
      key: "checkPdf",
      value: function checkPdf(location) {
        this.FileService.checkPdf(location);
      }
    }, {
      key: "scrollToAnchor",
      value: function scrollToAnchor(letter) {
        this.$location.hash(letter);
        this.$anchorScroll();
      }
    }]);

    return affiliationIndexController;
  }());
})();
"use strict";

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

(function () {
  "use strict";

  angular.module("webpub").controller("authorIndexController", function () {
    function authorIndexController(authors, FileService, $anchorScroll, $location, $state, jwt) {
      _classCallCheck(this, authorIndexController);

      this.authors = authors;
      this.FileService = FileService;
      this.$anchorScroll = $anchorScroll;
      this.$location = $location;
      this.$state = $state;
      this.jwt = jwt;
    }

    _createClass(authorIndexController, [{
      key: "authorNameStartsWithLetter",
      value: function authorNameStartsWithLetter(name, letter) {
        if (letter === "#") {
          // get alphabet letters
          var alphabet = _.tail(this.alphabet);

          // If there is no match for any alphabet letter then consider this a digit
          return !_.some(alphabet, function (nextLetter) {
            return name.slice(0, 1).localeCompare(nextLetter, "en", {
              usage: "search",
              sensitivity: "base",
              ignorePunctuation: true
            }) !== 0;
          });
        } else {
          // check if the string matches the current letter
          return name.slice(0, 1).localeCompare(letter, "en", {
            usage: "search",
            sensitivity: "base",
            ignorePunctuation: true
          }) === 0;
        }
      }
    }, {
      key: "$onInit",
      value: function $onInit() {
        var _this = this;

        this.alphabet = "#ABCDEFGHIJKLMNOPQRSTUVWXYZ".split("");
        var startIdx = 0;
        this.authorMap = this.alphabet.reduce(function (authorMap, letter) {
          // get the cutoff index
          // this is the start index of the next authors
          // the authors under the final alphabet listing with have cutoff = -1
          var cutOff = _this.authors.findIndex(function (a, idx) {
            return idx >= startIdx && !_this.authorNameStartsWithLetter(a.authorName, letter);
          });

          // apply the cutoff
          if (cutOff >= 0) {
            // console.log(
            //   letter,
            //   startIdx,
            //   cutOff,
            //   this.authors.slice(startIdx, cutOff)
            // );
            authorMap[letter] = _this.authors.slice(startIdx, cutOff);
            startIdx = cutOff;
          }
          // handle the final authors
          else {
              // console.log(letter, startIdx, cutOff, this.authors.slice(startIdx));
              authorMap[letter] = _this.authors.slice(startIdx);
            }
          return authorMap;
        }, {});
        this.authorMap["A"] = (this.authorMap["#"] || []).concat(this.authorMap["A"]);
        delete this.authorMap["#"];
        this.alphabet = this.alphabet.slice(1);
        // console.log("authorMap: ", this.authorMap);
      }
    }, {
      key: "checkPdf",
      value: function checkPdf(location) {
        this.FileService.checkPdf(location);
      }
    }, {
      key: "scrollToAnchor",
      value: function scrollToAnchor(letter) {
        this.$location.hash(letter);
        this.$anchorScroll();
      }
    }]);

    return authorIndexController;
  }());
})();
"use strict";

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

(function () {
  "use strict";

  angular.module("webpub").controller("bannerController", function () {
    function bannerController(ConfigService) {
      _classCallCheck(this, bannerController);

      this.config = ConfigService;
    }

    _createClass(bannerController, [{
      key: "$onInit",
      value: function $onInit() {
        this.bannerFile = this.config.bannerFile;
      }
    }]);

    return bannerController;
  }());
})();
"use strict";

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

(function () {
  "use strict";

  angular.module("webpub").controller("extraPageController", function () {
    function extraPageController($state, pages, pageName, location, jwt) {
      _classCallCheck(this, extraPageController);

      this.$state = $state;
      this.pages = pages;
      this.pageName = pageName;
      this.location = location;
      this.jwt = jwt;
    }

    _createClass(extraPageController, [{
      key: "$onInit",
      value: function $onInit() {
        console.log("pageName: ", this.pageName);
        console.log("location: ", this.location);
        console.log("pages: ", this.pages);
      }
    }]);

    return extraPageController;
  }());
})();
"use strict";

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

(function () {
  "use strict";

  angular.module("webpub").controller("loginController", function () {
    function loginController(LoginService) {
      _classCallCheck(this, loginController);

      this.LoginService = LoginService;
    }

    _createClass(loginController, [{
      key: "$onInit",
      value: function $onInit() {}
    }, {
      key: "login",
      value: function login() {
        var _this = this;

        this.LoginService.login(this.username, this.password).catch(function (err) {
          _this.loading = false;
        });
        this.loading = true;
      }
    }]);

    return loginController;
  }());
})();
"use strict";

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

(function () {
  "use strict";

  angular.module("webpub").controller("navController", function () {
    function navController(DataService, ConfigService, AdditionalPagesService, NotificationService, LoginService, HTTPService) {
      _classCallCheck(this, navController);

      this.DataService = DataService;
      this.config = ConfigService;
      this.additionalPages = AdditionalPagesService;
      this.NotificationService = NotificationService;
      this.LoginService = LoginService;
      this.HTTPService = HTTPService;
    }

    _createClass(navController, [{
      key: "$onInit",
      value: function $onInit() {
        this.conferences = this.DataService.webpub.data.conferences;
        this.webpubDownloadEnabled = this.config.webpubDownload && this.config.webpubDownload.enabled;
        this.authEnabled = this.config.services && this.config.services.authEnabled;
      }
    }, {
      key: "onWebpubDownloadClicked",
      value: function onWebpubDownloadClicked($event) {
        $event.preventDefault();

        var downloadParams = "";
        var jwt = null;
        if (this.webpubDownloadEnabled) {
          if (this.authEnabled) {
            jwt = this.LoginService.checkAndResolveJWT();
            downloadParams = jwt ? "?token=" + jwt.token : "";
          }
        }
        var webpubDownloadLocation = "" + this.config.webpubDownload.location + downloadParams;

        // check if auth needed
        if (this.authEnabled && !jwt) {
          this.NotificationService.send("danger", "You must be logged in to do that.");
          return;
        }

        // track download if enabled
        // TODO move to service
        if (this.config.services && this.config.services.trackingEnabled) {
          var trackingURL = this.config.services && this.config.services.trackingURL;
          if (!trackingURL) {
            console.error("trackingURL not defined in config.services");
            return;
          }
          var strategy = this.config.services && this.config.services.strategy;
          if (!strategy) {
            console.error("strategy not defined in config.services");
            return;
          }

          this.HTTPService.post(trackingURL, {
            action: "webpub download",
            strategy: strategy
          }, jwt).catch(function (error) {
            console.error("Webpub download tracking error: ", error);
          });
        }

        window.open(webpubDownloadLocation, "_blank");
      }
    }]);

    return navController;
  }());
})();
"use strict";

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

(function () {
  "use strict";

  var RESERVED_OBJECT_PROPERTIES = new Set(Object.getOwnPropertyNames(Object.prototype));

  angular.module("webpub").controller("searchController", function () {
    function searchController(conferences, FileService, jwt) {
      _classCallCheck(this, searchController);

      this.conferences = conferences;
      this.FileService = FileService;
      this.jwt = jwt;
    }

    _createClass(searchController, [{
      key: "$onInit",
      value: function $onInit() {
        this.searchMap = this.conferences.reduce(function (searchMap, conference) {
          conference.sections.forEach(function (section) {
            section.lineItems.forEach(function (entry) {
              entry.searchText.toLowerCase().split(" ").forEach(function (token) {
                var isTokenReserved = RESERVED_OBJECT_PROPERTIES.has(token);
                token = isTokenReserved ? "___" + token : token;
                var entryList = searchMap[token] || [];
                entryList.push(entry);
                searchMap[token] = entryList;
              });
            });
          });
          return searchMap;
        }, {});

        this.eidMap = this.conferences.reduce(function (eidMap, conference) {
          conference.sections.forEach(function (section) {
            section.lineItems.forEach(function (entry) {
              eidMap[entry.eid] = entry;
            });
          });
          return eidMap;
        }, {});
      }
    }, {
      key: "checkPdf",
      value: function checkPdf(item) {
        this.FileService.checkPdf(item.articleLocation);
      }
    }, {
      key: "getAbstract",
      value: function getAbstract(entry) {
        return entry.abstract || "No abstract provided";
      }
    }, {
      key: "searchInput",
      value: function searchInput() {
        var _this = this;

        if (this.searchTerm.length < 3) return;

        var hitMap = this.searchTerm.split(" ").filter(function (token) {
          return token;
        }).reduce(function (hitMap, token) {
          var isTokenReserved = RESERVED_OBJECT_PROPERTIES.has(token.toLowerCase());
          token = (isTokenReserved ? "___" + token : token).toLowerCase();
          if (!_this.searchMap[token]) return hitMap;

          _this.searchMap[token].forEach(function (entry) {
            var hits = hitMap[entry.eid] || 0;
            hits += 1;
            hitMap[entry.eid] = hits;
          });

          return hitMap;
        }, {});

        this.searchResults = Object.keys(hitMap).map(function (eid) {
          return {
            entry: _this.eidMap[eid],
            hits: hitMap[eid]
          };
        }).sort(function (a, b) {
          return b.hits - a.hits;
        }).map(function (result) {
          return result.entry;
        });

        console.log("results: ", this.searchResults);
      }
    }]);

    return searchController;
  }());
})();
"use strict";

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

(function () {
  "use strict";

  angular.module("webpub").controller("tocController", function () {
    function tocController(conference, FileService, $scope, $location, $anchorScroll, VideoPlayerService, ConfigService, jwt) {
      _classCallCheck(this, tocController);

      this.conference = conference;
      this.FileService = FileService;
      this.$scope = $scope;
      this.$location = $location;
      this.$anchorScroll = $anchorScroll;
      this.VideoPlayerService = VideoPlayerService;
      this.ConfigService = ConfigService;
      this.jwt = jwt;
    }

    _createClass(tocController, [{
      key: "$onInit",
      value: function $onInit() {
        var _this = this;

        this.playerSetting = this.ConfigService.videoPlayer || "default";
        this.conference.backMatter = this.conference.backMatter.filter(function (entry) {
          return entry.type !== "BM_ROSTER";
        });
        this.anchors = [{ name: "Jump to Section...", value: "jump" }, { name: "\u2022 Front Matter", value: "FrontMatter" }].concat(this.conference.sections.map(function (s) {
          var indent = s.type === "SD_TRACK" ? "" : s.type === "SD_SESSION" ? "\xA0\xA0\xA0" : "\xA0\xA0\xA0\xA0\xA0\xA0";
          console.log(s);
          return {
            name: indent + "\u2022\xA0" + s.title,
            value: _this.getTitleId(s.title)
          };
        })).concat([{ name: "\u2022 Back Matter", value: "BackMatter" }]);
        this.selectedAnchor = "jump";

        this.$scope.$watch(function () {
          return _this.selectedAnchor;
        }, function () {
          if (_this.selectedAnchor !== "jump") {
            _this.$location.hash(_this.selectedAnchor);
            _this.$anchorScroll();
          }
        });
      }
    }, {
      key: "checkPdf",
      value: function checkPdf(item) {
        this.FileService.checkPdf(item.articleLocation);
      }
    }, {
      key: "handleExtraClick",
      value: function handleExtraClick(entry, extra, $event) {
        // if the extra is a video -> defer to the video player service
        if (this.useVideoPlayer(extra)) {
          $event.preventDefault();
          this.VideoPlayerService.openVideo(entry, extra, this.jwt).catch(function (err) {
            return console.error(err);
          });
        }
        // Otherwise check that the file exists -> display a notification if not found
        else {
            this.FileService.checkExtra(extra.location);
          }
      }
    }, {
      key: "useVideoPlayer",
      value: function useVideoPlayer(extra) {
        return this.VideoPlayerService.isMP4(extra.location) && this.playerSetting !== "link";
      }
    }, {
      key: "getTitleId",
      value: function getTitleId(title) {
        return title.replace(/ /g, "");
      }
    }, {
      key: "getSectionClass",
      value: function getSectionClass(section) {
        if (section.class === "SD") if (section.type === "SD_SESSION") {
          return "h4";
        } else if (section.type === "SD_SUBSESSION") {
          return "h5";
        } else if (section.type === "SD_TRACK") {
          return "h3";
        }
      }
    }, {
      key: "chairName",
      value: function chairName(section) {
        return section.chair && section.chair.title && section.chair.name ? section.chair.title + ": " + section.chair.name : "";
      }
    }]);

    return tocController;
  }());
})();
"use strict";

(function () {
  "use strict";

  angular.module("webpub").filter("entryPageNumberFilter", function () {
    return function (entry) {
      if (!entry) return entry;
      if (!entry.pageNumber) return entry.pageNumber;
      if (entry.isPageNumberRoman) {
        return toRoman(entry.pageNumber);
      } else {
        return entry.pageNumber;
      }
    };
  });

  function toRoman(num) {
    var result = "";
    var decimal = [1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1];
    var roman = ["m", "cm", "d", "cd", "c", "xc", "l", "xl", "x", "ix", "v", "iv", "i"];
    for (var i = 0; i <= decimal.length; i++) {
      while (num % decimal[i] < num) {
        result += roman[i];
        num -= decimal[i];
      }
    }
    return result;
  }
})();
"use strict";

(function () {
  "use strict";

  angular.module("webpub").filter("extraLinkFilter", ["ConfigService", "VideoPlayerService", function (ConfigService, VideoPlayerService) {
    var playerSetting = ConfigService.videoPlayer || "default";
    return function (extra) {
      // if its an MP4 video and we're not using "link" mode
      // return an empty link
      if (VideoPlayerService.isMP4(extra.location) && playerSetting !== "link") {
        return "#";
      }
      // otherwise return a link to the extra file
      else {
          return extra.location;
        }
    };
  }]);
})();
"use strict";

(function () {
  "use strict";

  angular.module("webpub").filter("fileUrlFilter", [function () {
    return function (url, jwt) {
      var tokenParam = jwt ? "?token=" + jwt.token : "";
      return "" + url + tokenParam;
    };
  }]);
})();
"use strict";

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

(function () {
  "use strict";

  angular.module("webpub").provider("FileService", function () {
    function _class() {
      _classCallCheck(this, _class);
    }

    _createClass(_class, [{
      key: "$get",
      value: function $get($window, NotificationService) {
        function checkFile(type, location) {
          if (!location) {
            NotificationService.send("danger", type + " file not found for article");
          }
        }

        function checkPdf(location) {
          return checkFile("PDF", location);
        }

        function checkExtra(location) {
          return checkFile("Extra", location);
        }

        return {
          checkPdf: checkPdf,
          checkExtra: checkExtra
        };
      }
    }]);

    return _class;
  }());
})();
"use strict";

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

(function () {
  "use strict";

  angular.module("webpub").provider("HTTPService", function () {
    function _class() {
      _classCallCheck(this, _class);
    }

    _createClass(_class, [{
      key: "$get",
      value: function $get($http) {
        var get = function get(url) {
          return $http({
            url: url,
            method: "GET"
            // headers: {
            //   'Content-Type': 'application/json; charset=utf-8'
            // }
          });
        };

        var post = function post(url, body, jwt) {
          var postOptions = {
            url: url,
            method: "POST",
            data: body,
            headers: {
              "Content-Type": "application/json; charset=utf-8"
            }
          };
          if (jwt) {
            postOptions.headers.Authorization = "Bearer " + jwt.token;
          }
          return $http(postOptions);
        };

        return {
          get: get,
          post: post
        };
      }
    }]);

    return _class;
  }());
})();
"use strict";

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

(function () {
  "use strict";

  angular.module("webpub").provider("LoginService", function () {
    function _class() {
      _classCallCheck(this, _class);
    }

    _createClass(_class, [{
      key: "verifyConfigHasFields",
      value: function verifyConfigHasFields(config, fields) {
        if (!config.services) {
          throw new Error("Services not defined in config");
        }
        fields.forEach(function (fieldName) {
          if (!config.services[fieldName]) {
            throw new Error(fieldName + " is not defined in config.services");
          }
        });
        return config.services;
      }
    }, {
      key: "$get",
      value: function $get(moment, $state, ConfigService, HTTPService, NotificationService, jwtHelper) {
        var _this = this;

        // this will only hold one element, but we want to use the push and pop methods
        var returnState = [];

        var login = function login(username, password) {
          var _verifyConfigHasField = _this.verifyConfigHasFields(ConfigService, ["confId", "strategy", "loginURL"]),
              confId = _verifyConfigHasField.confId,
              strategy = _verifyConfigHasField.strategy,
              loginURL = _verifyConfigHasField.loginURL;

          return HTTPService.post(loginURL, {
            username: username,
            password: password,
            confId: confId,
            strategy: strategy
          }).then(function (response) {
            storeJWTtoLocalStorage(response.data.jwt);

            var _ref = returnState.pop() || {
              state: "home",
              stateParams: {}
            },
                state = _ref.state,
                stateParams = _ref.stateParams;

            $state.go(state, stateParams);
          }).catch(function (error) {
            console.error("Login Error: ", error);
            NotificationService.send("danger", "Invalid username or password");
            throw error;
          });
        };

        var checkAndResolveJWT = function checkAndResolveJWT(currentState, stateParams) {
          if (!ConfigService.services || !ConfigService.services.authEnabled) {
            return null;
          }

          var _verifyConfigHasField2 = _this.verifyConfigHasFields(ConfigService, ["confId"]),
              confId = _verifyConfigHasField2.confId;

          var jwtString = localStorage.getItem(confId + "_JWT");

          // check if a JWT exists
          if (!jwtString) {
            console.error("JWT not found");
            if (currentState) {
              returnState.push({ state: currentState, stateParams: stateParams });
            }
            return null;
          }

          // check the expiration date
          if (jwtHelper.isTokenExpired(jwtString)) {
            console.error("JWT is expired");
            if (currentState) {
              returnState.push({ state: currentState, stateParams: stateParams });
            }
            return null;
          }

          // return the jwtString and decodedJWT if the above checks pass
          return {
            token: jwtString,
            data: jwtHelper.decodeToken(jwtString)
          };
        };

        var storeJWTtoLocalStorage = function storeJWTtoLocalStorage(jwtToken) {
          var _verifyConfigHasField3 = _this.verifyConfigHasFields(ConfigService, ["confId"]),
              confId = _verifyConfigHasField3.confId;

          localStorage.setItem(confId + "_JWT", jwtToken);
        };

        return {
          login: login,
          checkAndResolveJWT: checkAndResolveJWT
        };
      }
    }]);

    return _class;
  }());
})();
"use strict";

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

(function () {
  "use strict";

  angular.module("webpub").provider("NotificationService", function () {
    function _class() {
      _classCallCheck(this, _class);
    }

    _createClass(_class, [{
      key: "$get",
      value: function $get() {
        var notifications = [];
        var send = function send(type, message) {
          notifications.push({
            type: type,
            message: message
          });
        };
        return {
          notifications: notifications,
          send: send
        };
      }
    }]);

    return _class;
  }());
})();
"use strict";

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

(function () {
  "use strict";

  angular.module("webpub").provider("TemplateService", function () {
    function _class() {
      _classCallCheck(this, _class);
    }

    _createClass(_class, [{
      key: "$get",
      value: function $get(helloTemplate, tocTemplate, authorIndexTemplate, iframeTemplate, searchTemplate, affiliationIndexTemplate, videoPlayerModalTemplate, loginTemplate) {
        return {
          getHello: function getHello() {
            return helloTemplate.content();
          },
          getToc: function getToc() {
            return tocTemplate.content();
          },
          getAuthorIndex: function getAuthorIndex() {
            return authorIndexTemplate.content();
          },
          getAffiliationIndex: function getAffiliationIndex() {
            return affiliationIndexTemplate.content();
          },
          getIframeTemplate: function getIframeTemplate() {
            return iframeTemplate.content();
          },
          getSearch: function getSearch() {
            return searchTemplate.content();
          },
          getVideoPlayer: function getVideoPlayer() {
            return videoPlayerModalTemplate.content();
          },
          getLogin: function getLogin() {
            return loginTemplate.content();
          }
        };
      }
    }]);

    return _class;
  }());
})();
"use strict";

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

(function () {
  "use strict";

  angular.module("webpub").provider("VideoPlayerService", function () {
    function _class() {
      _classCallCheck(this, _class);
    }

    _createClass(_class, [{
      key: "$get",
      value: function $get($uibModal, ConfigService) {
        function isMP4(filename) {
          return filename.split(".").slice(-1)[0].toLowerCase() === "mp4";
        }

        function openVideo(_entry, _extra, _jwt) {
          var modal = $uibModal.open({
            component: "webpubVideoPlayerModal",
            size: "lg",
            resolve: {
              entry: function entry() {
                return _entry;
              },
              extra: function extra() {
                return _extra;
              },
              jwt: function jwt() {
                return _jwt;
              },
              playerSetting: getPlayerSetting
            }
          });

          return modal.result;
        }

        function getPlayerSetting() {
          var configSetting = ConfigService.videoPlayer;
          console.log("player configuration setting: ", configSetting);
          if (configSetting && configSetting !== "default") {
            return configSetting;
          } else {
            var proto = window.location.protocol;
            if (proto.toLowerCase().startsWith("file")) {
              console.log("Detected file protocol");
              return "native";
            } else {
              console.log("Detected hosted protocol");
              return "native";
            }
          }
        }

        return {
          openVideo: openVideo,
          isMP4: isMP4
        };
      }
    }]);

    return _class;
  }());
})();
"use strict";

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

(function () {
  "use strict";

  angular.module("webpub").component("webpubNotifications", {
    bindings: {},
    controller: function () {
      function controller(NotificationService) {
        _classCallCheck(this, controller);

        this.NotificationService = NotificationService;
      }

      _createClass(controller, [{
        key: "$onInit",
        value: function $onInit() {
          this.notifications = this.NotificationService.notifications;
        }
      }]);

      return controller;
    }(),
    template: "<!-- Hide the notifications module until the application loads. -->\n                <div data-ng-cloak>\n                    <div class=\"notifications\"\n                         data-growl-notifications\n                         data-ng-if=\"$ctrl.notifications\">\n                \n                        <!-- (notifications) Notifications list -->\n                        <div data-ng-repeat=\"notification in $ctrl.notifications\">\n                            <div class=\"notification fading\"\n                                 data-growl-notification\n                                 data-ng-class=\"notification.type\">{{ notification.message }}</div>\n                        </div>                \n                    </div>\n                </div>\n                "
  });
})();
"use strict";

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

(function () {
  "use strict";

  angular.module("webpub").component("webpubVideoPlayerModal", {
    bindings: {
      close: "&",
      dismiss: "&",
      size: "@",
      resolve: "<"
    },
    template: function template(TemplateService) {
      return TemplateService.getVideoPlayer();
    },
    controller: function () {
      function controller($scope) {
        _classCallCheck(this, controller);

        this.$scope = $scope;
      }

      _createClass(controller, [{
        key: "$onInit",
        value: function $onInit() {
          var _this = this;

          // handle resolves
          this.entry = this.resolve.entry;
          this.extra = this.resolve.extra;
          this.playerSetting = this.resolve.playerSetting;
          this.jwt = this.resolve.jwt;

          // declare helper variables
          var playerSetting = this.playerSetting;
          this.isNative = false;
          this.isVideoJs = false;
          this.isMediaElement = false;

          // set player type variables
          if (playerSetting === "videojs") {
            this.isVideoJs = true;
          } else if (playerSetting === "mediaelement") {
            this.isMediaElement = true;
          } else {
            this.isNative = true;
          }

          // clean up non-native player objects when modal closes
          this.$scope.$on("modal.closing", function (event, reason, closed) {
            console.log("modal closing: ", event, reason, closed);
            if (_this.isVideoJs) {
              // call dispose if player type is videoJs
              _this.videoPlayer.dispose();
            } else if (_this.isMediaElement) {
              // pause then remove player if type is MediaElement
              if (!_this.videoPlayer.paused) {
                _this.videoPlayer.pause();
              }
              _this.videoPlayer.remove();
            }
          });
        }

        // $postLink is called after components and children are added to DOM

      }, {
        key: "$postLink",
        value: function $postLink() {
          this.setSource();
          // initialize MediaElement player
          if (this.isMediaElement) {
            this.videoPlayer = new MediaElementPlayer("videoPlayer", {
              defaultVideoHeight: 480,
              success: function success(mediaElement, node, instance) {
                console.log("Media element player is loaded: ", mediaElement, node, instance);
                node.classList.add("height-width-100");
              },
              error: function error(_error, mediaElement, node) {
                console.error("Error loading media element player: ", _error, media, node);
              }
            });
          }
          // initialize videoJs player
          else if (this.isVideoJs) {
              this.setSource();
              this.setVideoClasses();
              this.videoPlayer = videojs("videoPlayer");
            }
            // initialize Native Video Source
            else {
                this.setVideoClasses();
                this.setSource();
              }
        }
      }, {
        key: "onClose",
        value: function onClose() {
          this.close();
        }

        /** The videoJs API seemed to not set the video source properly when using the usual angular handlebars
         * Good ol' JQuery should do the trick
         */

      }, {
        key: "setSource",
        value: function setSource() {
          var videoSource = angular.element("#videoSource");
          var jwtParam = this.jwt ? "?token=" + this.jwt.token : "";
          videoSource.attr("src", "" + this.extra.location + jwtParam);
        }

        /**
         * Set classes specific to the video player being used
         * This seems to work better in JQuery for some players
         */

      }, {
        key: "setVideoClasses",
        value: function setVideoClasses() {
          var videoPlayer = angular.element("#videoPlayer");
          var videoWrapper = angular.element("#videoWrapper");
          if (this.isVideoJs) {
            videoPlayer.addClass("video-js vjs-16-9");
          } else if (this.isMediaElement) {
            videoPlayer.addClass("height-width-100");
          } else {
            videoPlayer.attr("height", 480);
            videoPlayer.css({ width: "100%", outline: "none" });
            videoWrapper.css("background-color", "#000");
          }
        }
      }]);

      return controller;
    }()
  });
})();
"use strict";

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

(function () {
    "use strict";

    angular.module("webpub").provider("affiliationIndexTemplate", function () {
        function _class() {
            _classCallCheck(this, _class);
        }

        _createClass(_class, [{
            key: "$get",
            value: function $get() {
                var content = function content() {
                    return "<div class=\"row\">\n    <div class=\"col-md-12\">\n        <div class=\"btn-toolbar pt\" role=\"toolbar\">\n            <div class=\"btn-group\">\n                <button class=\"btn btn-default\" data-ng-repeat=\"letter in $ctrl.alphabet\" data-ng-click=\"$ctrl.scrollToAnchor(letter)\">{{letter}}</button>\n            </div>\n        </div>\n    </div>    \n</div>\n<div class=\"row\">\n    <div class=\"col-md-12\">\n        <h1>Affiliation Index</h1>\n        <div data-ng-repeat=\"letter in $ctrl.alphabet\">\n            <h3 id=\"{{letter}}\">{{letter}}</h3>\n            <div data-ng-repeat=\"aff in $ctrl.affiliationMap[letter]\">\n                <p style=\"margin-bottom: 0\">{{aff.affiliation}}</p>\n                <div data-ng-repeat=\"article in aff.articleRefs\"\n                     style=\"margin-bottom: 5px\">\n                    <p data-ng-if=\"!article.articleLocation\" style=\"color: #23527c;\">{{article.articleName}}</p>\n                    <a data-ng-if=\"article.articleLocation\" data-ng-href=\"{{article.articleLocation | fileUrlFilter : $ctrl.jwt}}\" target=\"_blank\" data-ng-click=\"$ctrl.checkPdf(article.articleLocation)\">{{article.articleName}}</a>\n                </div>\n            </div>\n        </div>        \n    </div>\n</div>\n\n";
                };

                return {
                    content: content
                };
            }
        }]);

        return _class;
    }());
})();
"use strict";

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

(function () {
    "use strict";

    angular.module("webpub").provider("authorIndexTemplate", function () {
        function _class() {
            _classCallCheck(this, _class);
        }

        _createClass(_class, [{
            key: "$get",
            value: function $get() {
                var content = function content() {
                    return "<div class=\"row\">\n    <div class=\"col-md-12\">\n        <div class=\"btn-toolbar pt\" role=\"toolbar\">\n            <div class=\"btn-group\">\n                <button class=\"btn btn-default\" data-ng-repeat=\"letter in $ctrl.alphabet\" data-ng-click=\"$ctrl.scrollToAnchor(letter)\">{{letter}}</button>\n            </div>\n        </div>\n    </div>    \n</div>\n<div class=\"row\">\n    <div class=\"col-md-12\">\n        <h1>Author Index</h1>\n        <div data-ng-repeat=\"letter in $ctrl.alphabet\">\n            <h3 id=\"{{letter}}\">{{letter}}</h3>\n            <div data-ng-repeat=\"author in $ctrl.authorMap[letter]\">\n                <p style=\"margin-bottom: 0\">{{author.authorName}}</p>\n                <div data-ng-repeat=\"article in author.articleRefs\"\n                     style=\"margin-bottom: 5px\">\n                    <p data-ng-if=\"!article.articleLocation\" style=\"color: #23527c;\">{{article.articleName}}</p>\n                    <a data-ng-if=\"article.articleLocation\" data-ng-href=\"{{article.articleLocation | fileUrlFilter : $ctrl.jwt}}\" target=\"_blank\" data-ng-click=\"$ctrl.checkPdf(article.articleLocation)\">{{article.articleName}}</a>\n                </div>\n            </div>\n        </div>        \n    </div>\n</div>\n\n";
                };

                return {
                    content: content
                };
            }
        }]);

        return _class;
    }());
})();
"use strict";

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

(function () {
  "use strict";

  angular.module("webpub").provider("helloTemplate", function () {
    function _class() {
      _classCallCheck(this, _class);
    }

    _createClass(_class, [{
      key: "$get",
      value: function $get() {
        var content = function content() {
          return "\n                        <div>{{$ctrl.hello()}}</div>\n                    ";
        };

        return {
          content: content
        };
      }
    }]);

    return _class;
  }());
})();
"use strict";

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

(function () {
  "use strict";

  angular.module("webpub").provider("iframeTemplate", function () {
    function _class() {
      _classCallCheck(this, _class);
    }

    _createClass(_class, [{
      key: "$get",
      value: function $get() {
        var content = function content() {
          return "<div class=\"row\">\n    <div class=\"col-md-12\">\n        <div class=\"embed-responsive embed-responsive-16by9\">\n            <iframe class=\"embed-responsive-item\" data-ng-src=\"{{$ctrl.location}}\"></iframe>\n        </div>        \n    </div>\n</div>";
        };

        return {
          content: content
        };
      }
    }]);

    return _class;
  }());
})();
"use strict";

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

(function () {
  "use strict";

  angular.module("webpub").provider("loginTemplate", function () {
    function _class() {
      _classCallCheck(this, _class);
    }

    _createClass(_class, [{
      key: "$get",
      value: function $get() {
        var content = function content() {
          return "\n          <div class=\"login-wrapper\">\n            <div class=\"login-formContent\">\n              <!-- Title -->\n              <div>\n                <h1 class=\"login-title\">Sign In</h1>\n              </div>\n        \n              <!-- Login Form -->\n              <form data-ng-hide=\"$ctrl.loading\" ng-submit=\"$ctrl.login()\">\n                <input type=\"text\" id=\"login\" name=\"login\" placeholder=\"Username\" class=\"login-input\" data-ng-model=\"$ctrl.username\">\n                <input type=\"password\" id=\"password\" name=\"login\" placeholder=\"Password\" class=\"login-input\" data-ng-model=\"$ctrl.password\">\n                <input data-ng-hide=$ctrl.loading type=\"submit\" class=\"login-button\" value=\"Sign In\">\n              </form>\n              \n              <div data-ng-show=\"$ctrl.loading\" class=\"pv-lg\">\n                <i class=\"fa fa-circle-o-notch fa-spin fa-3x fa-fw loading\"></i>\n                <span class=\"sr-only\">Loading...</span>\n              </div>\n              \n        \n              <!-- Remind Passowrd -->\n              <!-- <div class=\"login-formFooter\">\n                <a class=\"underlineHover\" href=\"#\">Go to the Site</a>\n              </div> -->\n        \n            </div>\n          </div>";
        };

        return {
          content: content
        };
      }
    }]);

    return _class;
  }());
})();
"use strict";

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

(function () {
    "use strict";

    angular.module("webpub").provider("searchTemplate", function () {
        function _class() {
            _classCallCheck(this, _class);
        }

        _createClass(_class, [{
            key: "$get",
            value: function $get() {
                var content = function content() {
                    return "<div class=\"row mt-lg\">\n    <div class=\"col-md-12\">\n        <div class=\"input-group custom-search-form\">\n            <input type=\"text\" class=\"form-control\" data-ng-change=\"$ctrl.searchInput()\" data-ng-model=\"$ctrl.searchTerm\" placeholder=\"Search...\">\n            <span class=\"input-group-btn\">\n                <button class=\"btn btn-default\" type=\"button\">\n                    <i class=\"fa fa-search\"></i>\n                </button>\n            </span>\n        </div>\n        <hr>\n        <h3 data-ng-if=\"$ctrl.searchResults && $ctrl.searchResults.length\">Results:</h3>\n        <div data-ng-repeat=\"result in $ctrl.searchResults\">\n            <p data-ng-if=\"!result.articleLocation\" class=\"text-bold\" style=\"color: #23527c;\">{{result.text}}</p>\n            <a data-ng-if=\"result.articleLocation\" class=\"text-bold\" data-ng-href=\"{{result.articleLocation | fileUrlFilter : $ctrl.jwt}}\" target=\"_blank\" ng-click=\"$ctrl.checkPdf(result)\">{{result.text}}</a>\n            <p class=\"pl-lg\"><em>{{result.authorNames}}</em></p>\n            <p class=\"pl-lg search-result\" data-ng-bind=\"$ctrl.getAbstract(result)\" data-ellipsis></p>\n        </div>\n    </div>\n</div>";
                };

                return {
                    content: content
                };
            }
        }]);

        return _class;
    }());
})();
"use strict";

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

(function () {
    "use strict";

    angular.module("webpub").provider("tocTemplate", function () {
        function _class() {
            _classCallCheck(this, _class);
        }

        _createClass(_class, [{
            key: "$get",
            value: function $get() {
                var content = function content() {
                    return "<div class=\"row\">\n    <div class=\"col-md-12\">\n        <div class=\"row\">\n            <div class=\"col-xs-8\">\n                <h1 class=\"text-bold\">{{$ctrl.conference.acronym}} {{$ctrl.conference.year}}</h1>\n            </div>\n            <div class=\"col-xs-4\">\n                <select class=\"form-control mt-xl\"\n                    data-ng-model=\"$ctrl.selectedAnchor\"\n                    data-ng-options=\"anchor.value as anchor.name for anchor in $ctrl.anchors\">                    \n                </select>\n            </div>\n        </div>        \n        <h2>{{$ctrl.conference.title}}</h2>\n        <h3>Table of Contents</h3>\n        <h3 class=\"text-bold\" id=\"FrontMatter\">Front Matter<span class=\"pull-right text-normal\">Page Number</span></h3>\n        <div data-ng-repeat=\"fm in $ctrl.conference.frontMatter\">\n            <p data-ng-if=\"!fm.articleLocation\" class=\"text-bold\" style=\"color: #23527c;\">{{fm.text}}<span class=\"pull-right\">{{fm | entryPageNumberFilter}}</p>\n            <a data-ng-if=\"fm.articleLocation\" class=\"text-bold\" data-ng-href=\"{{fm.articleLocation | fileUrlFilter : $ctrl.jwt}}\" target=\"_blank\" ng-click=\"$ctrl.checkPdf(fm)\">{{fm.text}}<span class=\"pull-right\">{{fm | entryPageNumberFilter}}</span></a>\n            <div data-ng-repeat=\"extra in fm.extraLocations\" class=\"pb\">\n                <a class=\"pl-lg\" data-ng-href=\"{{extra | extraLinkFilter | fileUrlFilter : $ctrl.jwt}}\" target=\"_blank\" data-ng-click=\"$ctrl.handleExtraClick(fm, extra, $event)\">\n                  <span data-ng-if=\"$ctrl.useVideoPlayer(extra)\" class=\"fa fa-video-camera mr-sm\"></span>\n                  {{extra.name}}\n                </a>\n            </div>\n        </div>\n        <div data-ng-repeat=\"section in $ctrl.conference.sections\">\n            <hr>\n            <h3 class=\"text-bold\" data-ng-class=\"$ctrl.getSectionClass(section)\" id=\"{{$ctrl.getTitleId(section.title)}}\">{{section.title}}</h3>\n            <p class=\"text-bold\">{{$ctrl.chairName(section)}}</p>\n            <div data-ng-repeat=\"item in section.lineItems\">\n                <p data-ng-if=\"!item.articleLocation\" class=\"text-bold\" style=\"color: #23527c;\">{{item.text}}<span class=\"pull-right\">{{item | entryPageNumberFilter}}</span></p>\n                <a data-ng-if=\"item.articleLocation\" class=\"text-bold\" data-ng-href=\"{{item.articleLocation | fileUrlFilter : $ctrl.jwt}}\" target=\"_blank\" ng-click=\"$ctrl.checkPdf(item)\">{{item.text}}<span class=\"pull-right\">{{item | entryPageNumberFilter}}</span></a>\n                <p class=\"pl-lg\"><em>{{item.authorNames}}</em></p>\n                <div data-ng-repeat=\"extra in item.extraLocations\" class=\"pb\">\n                    <a class=\"pl-lg\" data-ng-href=\"{{extra | extraLinkFilter | fileUrlFilter : $ctrl.jwt}}\" target=\"_blank\" data-ng-click=\"$ctrl.handleExtraClick(item, extra, $event)\">\n                      <span data-ng-if=\"$ctrl.useVideoPlayer(extra)\" class=\"fa fa-video-camera mr-sm\"></span>\n                      {{extra.name}}\n                    </a>                    \n                </div>\n                \n            </div>\n        </div>\n        <hr>\n        <h3 class=\"text-bold\" id=\"BackMatter\"></h3>\n        <div data-ng-repeat=\"bm in $ctrl.conference.backMatter\">\n            <p data-ng-if=\"!bm.articleLocation\" class=\"text-bold\" style=\"color: #23527c;\">{{bm.text}}<span class=\"pull-right\">{{bm | entryPageNumberFilter}}</span></p>\n            <a data-ng-if=\"bm.articleLocation\" class=\"text-bold\" data-ng-href=\"{{bm.articleLocation | fileUrlFilter : $ctrl.jwt}}\" target=\"_blank\" ng-click=\"$ctrl.checkPdf(bm)\">{{bm.text}}<span class=\"pull-right\">{{bm | entryPageNumberFilter}}</span></a>\n            <div data-ng-repeat=\"extra in bm.extraLocations\" class=\"pb\">\n                <a class=\"pl-lg\" data-ng-href=\"{{extra | extraLinkFilter | fileUrlFilter : $ctrl.jwt}}\" target=\"_blank\" data-ng-click=\"$ctrl.handleExtraClick(bm, extra, $event)\">\n                    <span data-ng-if=\"$ctrl.useVideoPlayer(extra)\" class=\"fa fa-video-camera mr-sm\"></span>\n                    {{extra.name}}\n                </a>\n            </div>\n        </div>\n    </div>\n</div>\n";
                };

                return {
                    content: content
                };
            }
        }]);

        return _class;
    }());
})();
"use strict";

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

(function () {
  "use strict";

  angular.module("webpub").provider("videoPlayerModalTemplate", function () {
    function _class() {
      _classCallCheck(this, _class);
    }

    _createClass(_class, [{
      key: "$get",
      value: function $get() {
        var content = function content() {
          return "\n<div class=\"modal-header\">\n    <button type=\"button\" class=\"close\" data-ng-click=\"$ctrl.onClose()\"><span>&times;</span></button>\n    <h4 class=\"modal-title\">{{$ctrl.entry.text}}&nbsp;{{$ctrl.playerSetting}}</h4>\n</div>\n<div class=\"modal-body\" id=\"modal-body\">\n    <div id=\"videoWrapper\">\n        <video id=\"videoPlayer\" controls=\"controls\">\n            <source id=videoSource src=\"\" type=\"video/mp4\" />\n        </video> \n    </div>          \n</div>\n";
        };

        return {
          content: content
        };
      }
    }]);

    return _class;
  }());
})();
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
