/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.embedded.fullscreen.osx;

import com.apple.eawt.AppEvent;
import com.apple.eawt.Application;
import com.apple.eawt.FullScreenAdapter;
import com.apple.eawt.FullScreenListener;
import com.apple.eawt.FullScreenUtilities;
import java.awt.Window;
import uk.co.caprica.vlcj.player.embedded.fullscreen.FullScreenStrategy;

public class OsxFullScreenStrategy
implements FullScreenStrategy {
    private final Window window;
    private boolean isFullScreenMode;

    public OsxFullScreenStrategy(Window window) {
        if (window == null) {
            throw new IllegalArgumentException("Window must not be null");
        }
        this.window = window;
        FullScreenUtilities.addFullScreenListenerTo((Window)window, (FullScreenListener)new FullScreenHandler());
        FullScreenUtilities.setWindowCanFullScreen((Window)window, (boolean)true);
    }

    @Override
    public void enterFullScreenMode() {
        Application.getApplication().requestToggleFullScreen(this.window);
    }

    @Override
    public void exitFullScreenMode() {
        Application.getApplication().requestToggleFullScreen(this.window);
    }

    @Override
    public boolean isFullScreenMode() {
        return this.isFullScreenMode;
    }

    protected void onBeforeEnterFullScreenMode() {
    }

    protected void onAfterExitFullScreenMode() {
    }

    private class FullScreenHandler
    extends FullScreenAdapter {
        private FullScreenHandler() {
        }

        public void windowEnteringFullScreen(AppEvent.FullScreenEvent event) {
            OsxFullScreenStrategy.this.isFullScreenMode = true;
            OsxFullScreenStrategy.this.onBeforeEnterFullScreenMode();
        }

        public void windowEnteredFullScreen(AppEvent.FullScreenEvent event) {
        }

        public void windowExitingFullScreen(AppEvent.FullScreenEvent event) {
            OsxFullScreenStrategy.this.isFullScreenMode = false;
        }

        public void windowExitedFullScreen(AppEvent.FullScreenEvent event) {
            OsxFullScreenStrategy.this.onAfterExitFullScreenMode();
        }
    }
}

