/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.base;

import java.util.ArrayList;
import java.util.List;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_player_t;
import uk.co.caprica.vlcj.player.base.BaseApi;
import uk.co.caprica.vlcj.player.base.ChapterDescription;
import uk.co.caprica.vlcj.player.base.Descriptions;
import uk.co.caprica.vlcj.player.base.MediaPlayer;

public final class ChapterApi
extends BaseApi {
    ChapterApi(MediaPlayer mediaPlayer) {
        super(mediaPlayer);
    }

    public int count() {
        return LibVlc.libvlc_media_player_get_chapter_count((libvlc_media_player_t)this.mediaPlayerInstance);
    }

    public int chapter() {
        return LibVlc.libvlc_media_player_get_chapter((libvlc_media_player_t)this.mediaPlayerInstance);
    }

    public void setChapter(int chapterNumber) {
        LibVlc.libvlc_media_player_set_chapter((libvlc_media_player_t)this.mediaPlayerInstance, (int)chapterNumber);
    }

    public void next() {
        LibVlc.libvlc_media_player_next_chapter((libvlc_media_player_t)this.mediaPlayerInstance);
    }

    public void previous() {
        LibVlc.libvlc_media_player_previous_chapter((libvlc_media_player_t)this.mediaPlayerInstance);
    }

    public List<ChapterDescription> descriptions(int title) {
        return Descriptions.chapterDescriptions(this.mediaPlayerInstance, title);
    }

    public List<ChapterDescription> descriptions() {
        return this.descriptions(this.mediaPlayer.titles().title());
    }

    public List<List<ChapterDescription>> allDescriptions() {
        int titleCount = this.mediaPlayer.titles().titleCount();
        ArrayList<List<ChapterDescription>> result = new ArrayList<List<ChapterDescription>>(Math.max(titleCount, 0));
        for (int i = 0; i < titleCount; ++i) {
            result.add(this.descriptions(i));
        }
        return result;
    }
}

