/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.media;

import com.sun.jna.Pointer;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.internal.libvlc_instance_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_close_cb;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_open_cb;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_read_cb;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_seek_cb;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_t;
import uk.co.caprica.vlcj.media.Media;
import uk.co.caprica.vlcj.media.MediaOptions;
import uk.co.caprica.vlcj.media.MediaRef;
import uk.co.caprica.vlcj.media.MediaResourceLocator;
import uk.co.caprica.vlcj.media.callback.CallbackMedia;

public final class MediaFactory {
    private MediaFactory() {
    }

    public static MediaRef newMediaRef(libvlc_instance_t libvlcInstance, libvlc_media_t mediaInstance, String ... options) {
        MediaRef result = MediaFactory.createMediaRef(libvlcInstance, mediaInstance, options);
        if (result != null) {
            LibVlc.libvlc_media_retain((libvlc_media_t)mediaInstance);
        }
        return result;
    }

    public static MediaRef newMediaRef(libvlc_instance_t libvlcInstance, String mrl, String ... options) {
        return MediaFactory.createMediaRef(libvlcInstance, MediaFactory.newMediaInstance(libvlcInstance, mrl), options);
    }

    public static MediaRef newMediaRef(libvlc_instance_t libvlcInstance, CallbackMedia callbackMedia, String ... options) {
        return MediaFactory.createMediaRef(libvlcInstance, MediaFactory.newMediaInstance(libvlcInstance, callbackMedia), options);
    }

    public static MediaRef newMediaRef(libvlc_instance_t libvlcInstance, Media media, String ... options) {
        return MediaFactory.createMediaRef(libvlcInstance, MediaFactory.retain(media.mediaInstance()), options);
    }

    public static MediaRef newMediaRef(libvlc_instance_t libvlcInstance, MediaRef mediaRef, String ... options) {
        return MediaFactory.createMediaRef(libvlcInstance, MediaFactory.retain(mediaRef.mediaInstance()), options);
    }

    public static MediaRef duplicateMediaRef(libvlc_instance_t libvlcInstance, MediaRef mediaRef, String ... options) {
        return MediaFactory.createMediaRef(libvlcInstance, LibVlc.libvlc_media_duplicate((libvlc_media_t)mediaRef.mediaInstance()), options);
    }

    public static Media newMedia(libvlc_instance_t libvlcInstance, libvlc_media_t mediaInstance, String ... options) {
        Media result = MediaFactory.createMedia(libvlcInstance, mediaInstance, options);
        if (result != null) {
            LibVlc.libvlc_media_retain((libvlc_media_t)mediaInstance);
        }
        return result;
    }

    public static Media newMedia(libvlc_instance_t libvlcInstance, String mrl, String ... options) {
        return MediaFactory.createMedia(libvlcInstance, MediaFactory.newMediaInstance(libvlcInstance, mrl), options);
    }

    public static Media newMedia(libvlc_instance_t libvlcInstance, CallbackMedia callbackMedia, String ... options) {
        return MediaFactory.createMedia(libvlcInstance, MediaFactory.newMediaInstance(libvlcInstance, callbackMedia), options);
    }

    public static Media newMedia(libvlc_instance_t libvlcInstance, MediaRef mediaRef, String ... options) {
        return MediaFactory.createMedia(libvlcInstance, MediaFactory.retain(mediaRef.mediaInstance()), options);
    }

    public static Media newMedia(libvlc_instance_t libvlcInstance, Media media, String ... options) {
        return MediaFactory.createMedia(libvlcInstance, MediaFactory.retain(media.mediaInstance()), options);
    }

    public static Media duplicateMedia(libvlc_instance_t libvlcInstance, Media media, String ... options) {
        return MediaFactory.createMedia(libvlcInstance, LibVlc.libvlc_media_duplicate((libvlc_media_t)media.mediaInstance()), options);
    }

    private static libvlc_media_t newMediaInstance(libvlc_instance_t libvlcInstance, String mrl) {
        return MediaResourceLocator.isLocation(mrl = MediaResourceLocator.encodeMrl(mrl)) ? LibVlc.libvlc_media_new_location((libvlc_instance_t)libvlcInstance, (String)mrl) : LibVlc.libvlc_media_new_path((libvlc_instance_t)libvlcInstance, (String)mrl);
    }

    private static libvlc_media_t newMediaInstance(libvlc_instance_t libvlcInstance, CallbackMedia callbackMedia) {
        return LibVlc.libvlc_media_new_callbacks((libvlc_instance_t)libvlcInstance, (libvlc_media_open_cb)callbackMedia.getOpen(), (libvlc_media_read_cb)callbackMedia.getRead(), (libvlc_media_seek_cb)callbackMedia.getSeek(), (libvlc_media_close_cb)callbackMedia.getClose(), (Pointer)callbackMedia.getOpaque());
    }

    private static libvlc_media_t retain(libvlc_media_t mediaInstance) {
        LibVlc.libvlc_media_retain((libvlc_media_t)mediaInstance);
        return mediaInstance;
    }

    private static MediaRef createMediaRef(libvlc_instance_t libvlcInstance, libvlc_media_t mediaInstance, String[] options) {
        if (mediaInstance != null) {
            MediaOptions.addMediaOptions(mediaInstance, options);
            return new MediaRef(libvlcInstance, mediaInstance);
        }
        return null;
    }

    private static Media createMedia(libvlc_instance_t libvlcInstance, libvlc_media_t mediaInstance, String ... options) {
        if (mediaInstance != null) {
            Media media = new Media(libvlcInstance, mediaInstance);
            media.options().add(options);
            return media;
        }
        return null;
    }
}

