/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.io;

import java.io.IOException;
import java.nio.ByteOrder;
import org.monte.media.io.ImageInputStreamImpl2;

public class ByteArrayImageInputStream
extends ImageInputStreamImpl2 {
    protected byte[] buf;
    protected int count;
    private final int arrayOffset;

    public ByteArrayImageInputStream(byte[] buf) {
        this(buf, ByteOrder.BIG_ENDIAN);
    }

    public ByteArrayImageInputStream(byte[] buf, ByteOrder byteOrder) {
        this(buf, 0, buf.length, byteOrder);
    }

    public ByteArrayImageInputStream(byte[] buf, int offset, int length, ByteOrder byteOrder) {
        this.buf = buf;
        this.streamPos = offset;
        this.count = Math.min(offset + length, buf.length);
        this.arrayOffset = offset;
        this.byteOrder = byteOrder;
    }

    @Override
    public synchronized int read() {
        this.flushBits();
        return this.streamPos < (long)this.count ? this.buf[(int)this.streamPos++] & 0xFF : -1;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) {
        this.flushBits();
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (this.streamPos >= (long)this.count) {
            return -1;
        }
        if (this.streamPos + (long)len > (long)this.count) {
            len = (int)((long)this.count - this.streamPos);
        }
        if (len <= 0) {
            return 0;
        }
        System.arraycopy(this.buf, (int)this.streamPos, b, off, len);
        this.streamPos += (long)len;
        return len;
    }

    public synchronized long skip(long n) {
        if (this.streamPos + n > (long)this.count) {
            n = (long)this.count - this.streamPos;
        }
        if (n < 0L) {
            return 0L;
        }
        this.streamPos += n;
        return n;
    }

    public synchronized int available() {
        return (int)((long)this.count - this.streamPos);
    }

    @Override
    public void close() {
    }

    @Override
    public long getStreamPosition() throws IOException {
        this.checkClosed();
        return this.streamPos - (long)this.arrayOffset;
    }

    @Override
    public void seek(long pos) throws IOException {
        this.checkClosed();
        this.flushBits();
        if (pos < this.flushedPos) {
            throw new IndexOutOfBoundsException("pos < flushedPos!");
        }
        this.streamPos = pos + (long)this.arrayOffset;
    }

    private void flushBits() {
        this.bitOffset = 0;
    }

    @Override
    public long length() {
        return this.count - this.arrayOffset;
    }
}

