/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.image;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageObserver;
import java.awt.image.WritableRaster;

public class SubpixAA {
    public static final Object HBGR;
    public static final Object VBGR;
    public static final Object HRGB;
    public static final Object VRGB;
    private BufferedImage sBuf;
    private BufferedImage dBuf;

    static {
        Object hrgb;
        Object hbgr;
        Object vrgb;
        Object vbgr;
        try {
            vbgr = RenderingHints.class.getField("VALUE_TEXT_ANTIALIAS_LCD_VBGR").get(null);
            vrgb = RenderingHints.class.getField("VALUE_TEXT_ANTIALIAS_LCD_VRGB").get(null);
            hbgr = RenderingHints.class.getField("VALUE_TEXT_ANTIALIAS_LCD_HBGR").get(null);
            hrgb = RenderingHints.class.getField("VALUE_TEXT_ANTIALIAS_LCD_HRGB").get(null);
        }
        catch (Exception ex) {
            hrgb = "HRGB";
            hbgr = "HBGR";
            vrgb = "VRGB";
            vbgr = "VBGR";
        }
        HBGR = hbgr;
        HRGB = hrgb;
        VBGR = vrgb;
        VRGB = vbgr;
    }

    public void drawAA(Graphics gr, BufferedImage img, int x, int y, int width, int height, ImageObserver observer) {
        Graphics2D g = (Graphics2D)gr;
        this.drawAA(gr, img, x, y, width, height, g.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING), observer);
    }

    public void drawAA(Graphics gr, BufferedImage img, int x, int y, int width, int height, Object method, ImageObserver observer) {
        if (img.getWidth() == width && img.getHeight() == height) {
            gr.drawImage(img, x, y, observer);
            return;
        }
        Graphics2D g = (Graphics2D)gr;
        Dimension sdim = SubpixAA.getSourceDimension(width, height, method);
        if (img.getWidth() != sdim.width || img.getHeight() != sdim.height) {
            if (this.sBuf == null || this.sBuf.getWidth() != sdim.width || this.sBuf.getHeight() != sdim.height) {
                this.sBuf = new BufferedImage(sdim.width, sdim.height, 1);
            }
            Graphics2D sg = this.sBuf.createGraphics();
            SubpixAA.setupRendering(sg);
            sg.drawImage(img, 0, 0, sdim.width, sdim.height, null);
            sg.dispose();
            img = this.sBuf;
        }
        if (this.dBuf == null || this.dBuf.getWidth() != width || this.dBuf.getHeight() != height) {
            this.dBuf = new BufferedImage(width, height, 1);
        }
        SubpixAA.aa(img, this.dBuf, method);
        g.drawImage((Image)this.dBuf, x, y, observer);
    }

    public static Dimension getSourceDimension(int width, int height, Object method) {
        Dimension dim = method == HRGB || method == HBGR ? new Dimension(width * 3, height) : (method == VRGB || method == VBGR ? new Dimension(width, height * 3) : new Dimension(width, height));
        return dim;
    }

    public static void aa(BufferedImage src, BufferedImage dst, Object m) {
        if (m == HRGB) {
            SubpixAA.aaHRGB(src, dst);
        } else if (m == HBGR) {
            SubpixAA.aaHBGR(src, dst);
        } else if (m == VRGB) {
            SubpixAA.aaVRGB(src, dst);
        } else if (m == VBGR) {
            SubpixAA.aaVBGR(src, dst);
        } else {
            Graphics2D g = dst.createGraphics();
            SubpixAA.setupRendering(g);
            g.drawImage(src, 0, 0, dst.getWidth(), dst.getHeight(), null);
            g.dispose();
        }
    }

    private static void setupRendering(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
    }

    public static void aaHRGB(BufferedImage src, BufferedImage dst) {
        WritableRaster sras = src.getRaster();
        WritableRaster dras = dst.getRaster();
        int[] s = ((DataBufferInt)sras.getDataBuffer()).getData();
        int[] d = ((DataBufferInt)dras.getDataBuffer()).getData();
        int sw = src.getWidth();
        int sh = src.getHeight();
        int dw = dst.getWidth();
        int dh = dst.getHeight();
        boolean wll = true;
        int wl = 2;
        int wc = 3;
        int wr = 2;
        boolean wrr = true;
        int tw = 9;
        int y = 0;
        while (y < dh) {
            int sxy = y * sw;
            int dxy = y * dw;
            int dxyeol = dxy + dw - 1;
            d[dxy] = ((s[sxy + 0] & 0xFF0000) * 6 + (s[sxy + 1] & 0xFF0000) * 2 + (s[sxy + 2] & 0xFF0000) * 1) / 9 & 0xFF0000 | ((s[sxy + 0] & 0xFF00) * 3 + (s[sxy + 1] & 0xFF00) * 3 + (s[sxy + 2] & 0xFF00) * 2 + (s[sxy + 3] & 0xFF00) * 1) / 9 & 0xFF00 | ((s[sxy + 0] & 0xFF) * 1 + (s[sxy + 1] & 0xFF) * 2 + (s[sxy + 2] & 0xFF) * 3 + (s[sxy + 3] & 0xFF) * 2 + (s[sxy + 4] & 0xFF) * 1) / 9;
            sxy += 3;
            ++dxy;
            while (dxy < dxyeol) {
                d[dxy] = ((s[sxy - 2] & 0xFF0000) * 1 + (s[sxy - 1] & 0xFF0000) * 2 + (s[sxy + 0] & 0xFF0000) * 3 + (s[sxy + 1] & 0xFF0000) * 2 + (s[sxy + 2] & 0xFF0000) * 1) / 9 & 0xFF0000 | ((s[sxy - 1] & 0xFF00) * 1 + (s[sxy - 0] & 0xFF00) * 2 + (s[sxy + 1] & 0xFF00) * 3 + (s[sxy + 2] & 0xFF00) * 2 + (s[sxy + 3] & 0xFF00) * 1) / 9 & 0xFF00 | ((s[sxy + 0] & 0xFF) * 1 + (s[sxy + 1] & 0xFF) * 2 + (s[sxy + 2] & 0xFF) * 3 + (s[sxy + 3] & 0xFF) * 2 + (s[sxy + 4] & 0xFF) * 1) / 9;
                sxy += 3;
                ++dxy;
            }
            d[dxy] = ((s[sxy - 2] & 0xFF0000) * 1 + (s[sxy - 1] & 0xFF0000) * 2 + (s[sxy + 0] & 0xFF0000) * 3 + (s[sxy + 1] & 0xFF0000) * 2 + (s[sxy + 2] & 0xFF0000) * 1) / 9 & 0xFF0000 | ((s[sxy - 1] & 0xFF00) * 1 + (s[sxy + 0] & 0xFF00) * 2 + (s[sxy + 1] & 0xFF00) * 3 + (s[sxy + 2] & 0xFF00) * 3) / 9 & 0xFF00 | ((s[sxy + 0] & 0xFF) * 1 + (s[sxy + 1] & 0xFF) * 2 + (s[sxy + 2] & 0xFF) * 6) / 9;
            ++y;
        }
    }

    public static void aaHBGR(BufferedImage src, BufferedImage dst) {
        WritableRaster sras = src.getRaster();
        WritableRaster dras = dst.getRaster();
        int[] s = ((DataBufferInt)sras.getDataBuffer()).getData();
        int[] d = ((DataBufferInt)dras.getDataBuffer()).getData();
        int sw = src.getWidth();
        int sh = src.getHeight();
        int dw = dst.getWidth();
        int dh = dst.getHeight();
        boolean wll = true;
        int wl = 2;
        int wc = 3;
        int wr = 2;
        boolean wrr = true;
        int tw = 9;
        int y = 0;
        while (y < dh) {
            int sxy = y * sw;
            int dxy = y * dw;
            int dxyeol = dxy + dw - 1;
            d[dxy] = ((s[sxy + 0] & 0xFF) * 6 + (s[sxy + 1] & 0xFF) * 2 + (s[sxy + 2] & 0xFF) * 1) / 9 | ((s[sxy + 0] & 0xFF00) * 3 + (s[sxy + 1] & 0xFF00) * 3 + (s[sxy + 2] & 0xFF00) * 2 + (s[sxy + 3] & 0xFF00) * 1) / 9 & 0xFF00 | ((s[sxy + 0] & 0xFF0000) * 1 + (s[sxy + 1] & 0xFF0000) * 2 + (s[sxy + 2] & 0xFF0000) * 3 + (s[sxy + 3] & 0xFF0000) * 2 + (s[sxy + 4] & 0xFF0000) * 1) / 9 & 0xFF0000;
            sxy += 3;
            ++dxy;
            while (dxy < dxyeol) {
                d[dxy] = ((s[sxy - 2] & 0xFF) * 1 + (s[sxy - 1] & 0xFF) * 2 + (s[sxy + 0] & 0xFF) * 3 + (s[sxy + 1] & 0xFF) * 2 + (s[sxy + 2] & 0xFF) * 1) / 9 | ((s[sxy - 1] & 0xFF00) * 1 + (s[sxy + 0] & 0xFF00) * 2 + (s[sxy + 1] & 0xFF00) * 3 + (s[sxy + 2] & 0xFF00) * 2 + (s[sxy + 3] & 0xFF00) * 1) / 9 & 0xFF00 | ((s[sxy + 0] & 0xFF0000) * 1 + (s[sxy + 1] & 0xFF0000) * 2 + (s[sxy + 2] & 0xFF0000) * 3 + (s[sxy + 3] & 0xFF0000) * 2 + (s[sxy + 4] & 0xFF0000) * 1) / 9 & 0xFF0000;
                sxy += 3;
                ++dxy;
            }
            d[dxy] = ((s[sxy - 2] & 0xFF) * 1 + (s[sxy - 1] & 0xFF) * 2 + (s[sxy + 0] & 0xFF) * 3 + (s[sxy + 1] & 0xFF) * 2 + (s[sxy + 2] & 0xFF) * 1) / 9 | ((s[sxy - 1] & 0xFF00) * 1 + (s[sxy + 0] & 0xFF00) * 2 + (s[sxy + 1] & 0xFF00) * 3 + (s[sxy + 2] & 0xFF00) * 3) / 9 & 0xFF00 | ((s[sxy + 0] & 0xFF0000) * 1 + (s[sxy + 1] & 0xFF0000) * 2 + (s[sxy + 2] & 0xFF0000) * 6) / 9 & 0xFF0000;
            ++y;
        }
    }

    public static void aaVRGB(BufferedImage src, BufferedImage dst) {
        WritableRaster sras = src.getRaster();
        WritableRaster dras = dst.getRaster();
        int[] s = ((DataBufferInt)sras.getDataBuffer()).getData();
        int[] d = ((DataBufferInt)dras.getDataBuffer()).getData();
        int sw = src.getWidth();
        int sh = src.getHeight();
        int dw = dst.getWidth();
        int dh = dst.getHeight();
        boolean wll = true;
        int wl = 2;
        int wc = 3;
        int wr = 2;
        boolean wrr = true;
        int tw = 9;
        int x = 0;
        while (x < dw) {
            int sxy = x;
            int dxy = x;
            int dxyeol = dxy + dw * (dh - 1);
            d[dxy] = ((s[sxy + 0] & 0xFF0000) * 6 + (s[sxy + sw] & 0xFF0000) * 2 + (s[sxy + sw * 2] & 0xFF0000) * 1) / 9 & 0xFF0000 | ((s[sxy + 0] & 0xFF00) * 3 + (s[sxy + sw] & 0xFF00) * 3 + (s[sxy + sw * 2] & 0xFF00) * 2 + (s[sxy + sw * 3] & 0xFF00) * 1) / 9 & 0xFF00 | ((s[sxy + 0] & 0xFF) * 1 + (s[sxy + sw] & 0xFF) * 2 + (s[sxy + sw * 2] & 0xFF) * 3 + (s[sxy + sw * 3] & 0xFF) * 2 + (s[sxy + sw * 4] & 0xFF) * 1) / 9;
            sxy += 3 * sw;
            dxy += dw;
            while (dxy < dxyeol) {
                d[dxy] = ((s[sxy - sw * 2] & 0xFF0000) * 1 + (s[sxy - sw] & 0xFF0000) * 2 + (s[sxy + 0] & 0xFF0000) * 3 + (s[sxy + sw] & 0xFF0000) * 2 + (s[sxy + sw * 2] & 0xFF0000) * 1) / 9 & 0xFF0000 | ((s[sxy - sw] & 0xFF00) * 1 + (s[sxy - 0] & 0xFF00) * 2 + (s[sxy + sw] & 0xFF00) * 3 + (s[sxy + sw * 2] & 0xFF00) * 2 + (s[sxy + sw * 3] & 0xFF00) * 1) / 9 & 0xFF00 | ((s[sxy + 0] & 0xFF) * 1 + (s[sxy + sw] & 0xFF) * 2 + (s[sxy + sw * 2] & 0xFF) * 3 + (s[sxy + sw * 3] & 0xFF) * 2 + (s[sxy + sw * 4] & 0xFF) * 1) / 9;
                sxy += 3 * sw;
                dxy += dw;
            }
            d[dxy] = ((s[sxy - sw * 2] & 0xFF0000) * 1 + (s[sxy - sw] & 0xFF0000) * 2 + (s[sxy + 0] & 0xFF0000) * 3 + (s[sxy + sw] & 0xFF0000) * 2 + (s[sxy + sw * 2] & 0xFF0000) * 1) / 9 & 0xFF0000 | ((s[sxy - sw] & 0xFF00) * 1 + (s[sxy + 0] & 0xFF00) * 2 + (s[sxy + sw] & 0xFF00) * 3 + (s[sxy + sw * 2] & 0xFF00) * 3) / 9 & 0xFF00 | ((s[sxy + 0] & 0xFF) * 1 + (s[sxy + sw] & 0xFF) * 2 + (s[sxy + sw * 2] & 0xFF) * 6) / 9;
            ++x;
        }
    }

    public static void aaVBGR(BufferedImage src, BufferedImage dst) {
        WritableRaster sras = src.getRaster();
        WritableRaster dras = dst.getRaster();
        int[] s = ((DataBufferInt)sras.getDataBuffer()).getData();
        int[] d = ((DataBufferInt)dras.getDataBuffer()).getData();
        int sw = src.getWidth();
        int sh = src.getHeight();
        int dw = dst.getWidth();
        int dh = dst.getHeight();
        boolean wll = true;
        int wl = 2;
        int wc = 3;
        int wr = 2;
        boolean wrr = true;
        int tw = 9;
        int x = 0;
        while (x < dw) {
            int sxy = x;
            int dxy = x;
            int dxyeol = dxy + dw * (dh - 1);
            d[dxy] = ((s[sxy + 0] & 0xFF) * 6 + (s[sxy + sw] & 0xFF) * 2 + (s[sxy + sw * 2] & 0xFF) * 1) / 9 | ((s[sxy + 0] & 0xFF00) * 3 + (s[sxy + sw] & 0xFF00) * 3 + (s[sxy + sw * 2] & 0xFF00) * 2 + (s[sxy + sw * 3] & 0xFF00) * 1) / 9 & 0xFF00 | ((s[sxy + 0] & 0xFF0000) * 1 + (s[sxy + sw] & 0xFF0000) * 2 + (s[sxy + sw * 2] & 0xFF0000) * 3 + (s[sxy + sw * 3] & 0xFF0000) * 2 + (s[sxy + sw * 4] & 0xFF0000) * 1) / 9 & 0xFF0000;
            sxy += 3 * sw;
            dxy += dw;
            while (dxy < dxyeol) {
                d[dxy] = ((s[sxy - sw * 2] & 0xFF) * 1 + (s[sxy - sw] & 0xFF) * 2 + (s[sxy + 0] & 0xFF) * 3 + (s[sxy + sw] & 0xFF) * 2 + (s[sxy + sw * 2] & 0xFF) * 1) / 9 | ((s[sxy - sw] & 0xFF00) * 1 + (s[sxy - 0] & 0xFF00) * 2 + (s[sxy + sw] & 0xFF00) * 3 + (s[sxy + sw * 2] & 0xFF00) * 2 + (s[sxy + sw * 3] & 0xFF00) * 1) / 9 & 0xFF00 | ((s[sxy + 0] & 0xFF0000) * 1 + (s[sxy + sw] & 0xFF0000) * 2 + (s[sxy + sw * 2] & 0xFF0000) * 3 + (s[sxy + sw * 3] & 0xFF0000) * 2 + (s[sxy + sw * 4] & 0xFF0000) * 1) / 9 & 0xFF0000;
                sxy += 3 * sw;
                dxy += dw;
            }
            d[dxy] = ((s[sxy - sw * 2] & 0xFF) * 1 + (s[sxy - sw] & 0xFF) * 2 + (s[sxy + 0] & 0xFF) * 3 + (s[sxy + sw] & 0xFF) * 2 + (s[sxy + sw * 2] & 0xFF) * 1) / 9 | ((s[sxy - sw] & 0xFF00) * 1 + (s[sxy + 0] & 0xFF00) * 2 + (s[sxy + sw] & 0xFF00) * 3 + (s[sxy + sw * 2] & 0xFF00) * 3) / 9 & 0xFF00 | ((s[sxy + 0] & 0xFF0000) * 1 + (s[sxy + sw] & 0xFF0000) * 2 + (s[sxy + sw * 2] & 0xFF0000) * 6) / 9 & 0xFF0000;
            ++x;
        }
    }
}

