/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.avi;

import java.io.IOException;
import java.nio.ByteOrder;
import java.util.zip.InflaterInputStream;
import javax.imageio.stream.ImageInputStream;
import org.monte.media.io.AppendableByteArrayInputStream;
import org.monte.media.io.ByteArrayImageInputStream;
import org.monte.media.io.ImageInputStreamImpl2;
import org.monte.media.io.UncachedImageInputStream;

public class ZMBVCodecCore {
    public static final int VIDEOMODE_NONE = 0;
    public static final int VIDEOMODE_1_BIT_PALETTIZED = 1;
    public static final int VIDEOMODE_2_BIT_PALETTIZED = 2;
    public static final int VIDEOMODE_4_BIT_PALETTIZED = 3;
    public static final int VIDEOMODE_8_BIT_PALETTIZED = 4;
    public static final int VIDEOMODE_15_BIT_BGR = 5;
    public static final int VIDEOMODE_16_BIT_BGR = 6;
    public static final int VIDEOMODE_24_BIT_BGR = 7;
    public static final int VIDEOMODE_32_BIT_BGR = 8;
    public static final int COMPRESSION_NONE = 0;
    public static final int COMPRESSION_ZLIB = 1;
    private int majorVersion;
    private int minorVersion;
    private int compressionType;
    private int videoFormat;
    private int blockWidth;
    private int blockHeight;
    private InflaterInputStream inflaterInputStream;
    private AppendableByteArrayInputStream byteArrayInputStream;
    private int[] palette;
    private byte[] blockDataBuf;
    private byte[] blockHeaderBuf;

    public boolean decode(byte[] inDat, int off, int length, int[] outDat, int[] prevDat, int width, int height, boolean onlyDecodeIfKeyframe) {
        int flags;
        ImageInputStreamImpl2 in;
        boolean isKeyframe;
        block20: {
            isKeyframe = false;
            in = new ByteArrayImageInputStream(inDat, off, length, ByteOrder.LITTLE_ENDIAN);
            flags = in.readUnsignedByte();
            boolean bl = isKeyframe = (flags & 1) != 0;
            if (!onlyDecodeIfKeyframe || isKeyframe) break block20;
            System.out.println("ZMBVCodec cannot decode delta without preceeding keyframe.");
            return false;
        }
        try {
            if (isKeyframe) {
                this.majorVersion = in.readUnsignedByte();
                this.minorVersion = in.readUnsignedByte();
                this.compressionType = in.readUnsignedByte();
                this.videoFormat = in.readUnsignedByte();
                this.blockWidth = in.readUnsignedByte();
                this.blockHeight = in.readUnsignedByte();
            }
            if (this.majorVersion != 0 || this.minorVersion != 1) {
                System.err.println("unsupported version " + this.majorVersion + "." + this.minorVersion);
                return isKeyframe;
            }
            switch (this.compressionType) {
                case 1: {
                    if (!isKeyframe && this.inflaterInputStream != null) {
                        AppendableByteArrayInputStream bais = this.byteArrayInputStream;
                        bais.appendBuffer(inDat, (int)in.getStreamPosition() + off, (int)((long)length - in.getStreamPosition()), true);
                    } else {
                        if (this.byteArrayInputStream != null) {
                            this.byteArrayInputStream.setBuffer(inDat, (int)in.getStreamPosition() + off, (int)((long)length - in.getStreamPosition()));
                        } else {
                            this.byteArrayInputStream = new AppendableByteArrayInputStream((byte[])inDat.clone(), (int)in.getStreamPosition() + off, (int)((long)length - in.getStreamPosition()));
                        }
                        if (this.inflaterInputStream != null) {
                            this.inflaterInputStream.close();
                        }
                        this.inflaterInputStream = new InflaterInputStream(this.byteArrayInputStream);
                    }
                    in = new UncachedImageInputStream(this.inflaterInputStream, ByteOrder.LITTLE_ENDIAN);
                    break;
                }
                case 0: {
                    System.out.println(" NO COMPRESSION");
                    return isKeyframe;
                }
                default: {
                    System.err.println("unsupported compression type " + this.compressionType);
                    return isKeyframe;
                }
            }
            switch (this.videoFormat) {
                case 4: {
                    this.decode8to32(in, outDat, prevDat, flags, width, height);
                    break;
                }
                case 5: {
                    this.decode15to32(in, outDat, prevDat, flags, width, height);
                    break;
                }
                case 6: {
                    this.decode16to32(in, outDat, prevDat, flags, width, height);
                    break;
                }
                case 8: {
                    this.decode32to32(in, outDat, prevDat, flags, width, height);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported video format " + this.videoFormat);
                }
            }
        }
        catch (IOException ex) {
            System.err.println("ZMBVCodecCore decoding, isKeyframe=" + isKeyframe);
            ex.printStackTrace();
        }
        return isKeyframe;
    }

    public boolean decode(byte[] inDat, int off, int length, byte[] outDat, byte[] prevDat, int width, int height, boolean onlyDecodeIfKeyframe) {
        int flags;
        ImageInputStreamImpl2 in;
        boolean isKeyframe;
        block17: {
            isKeyframe = false;
            in = new ByteArrayImageInputStream(inDat, off, length, ByteOrder.LITTLE_ENDIAN);
            flags = in.readUnsignedByte();
            boolean bl = isKeyframe = (flags & 1) != 0;
            if (!onlyDecodeIfKeyframe || isKeyframe) break block17;
            System.out.println("ZMBVCodec cannot decode delta without preceeding keyframe.");
            return false;
        }
        try {
            if (isKeyframe) {
                this.majorVersion = in.readUnsignedByte();
                this.minorVersion = in.readUnsignedByte();
                this.compressionType = in.readUnsignedByte();
                this.videoFormat = in.readUnsignedByte();
                this.blockWidth = in.readUnsignedByte();
                this.blockHeight = in.readUnsignedByte();
            }
            if (this.majorVersion != 0 || this.minorVersion != 1) {
                System.err.println("unsupported version " + this.majorVersion + "." + this.minorVersion);
                return isKeyframe;
            }
            switch (this.compressionType) {
                case 1: {
                    if (!isKeyframe && this.inflaterInputStream != null) {
                        AppendableByteArrayInputStream bais = this.byteArrayInputStream;
                        bais.appendBuffer(inDat, (int)in.getStreamPosition() + off, (int)((long)length - in.getStreamPosition()), true);
                    } else {
                        if (this.byteArrayInputStream != null) {
                            this.byteArrayInputStream.setBuffer(inDat, (int)in.getStreamPosition() + off, (int)((long)length - in.getStreamPosition()));
                        } else {
                            this.byteArrayInputStream = new AppendableByteArrayInputStream((byte[])inDat.clone(), (int)in.getStreamPosition() + off, (int)((long)length - in.getStreamPosition()));
                        }
                        if (this.inflaterInputStream != null) {
                            this.inflaterInputStream.close();
                        }
                        this.inflaterInputStream = new InflaterInputStream(this.byteArrayInputStream);
                    }
                    in = new UncachedImageInputStream(this.inflaterInputStream, ByteOrder.LITTLE_ENDIAN);
                    break;
                }
                case 0: {
                    System.out.println(" NO COMPRESSION");
                    return isKeyframe;
                }
                default: {
                    System.err.println("unsupported compression type " + this.compressionType);
                    return isKeyframe;
                }
            }
            switch (this.videoFormat) {
                case 4: {
                    this.decode8to8(in, outDat, prevDat, flags, width, height);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported video format " + this.videoFormat);
                }
            }
        }
        catch (IOException ex) {
            System.err.println("ZMBVCodecCore decoding, isKeyframe=" + isKeyframe);
            ex.printStackTrace();
        }
        return isKeyframe;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int decode(byte[] inDat, int off, int length, Object[] outDatHolder, Object[] prevDatHolder, int width, int height, boolean onlyDecodeIfKeyframe) {
        int n;
        boolean isKeyframe = false;
        int depth = 0;
        try {
            ImageInputStreamImpl2 in = new ByteArrayImageInputStream(inDat, off, length, ByteOrder.LITTLE_ENDIAN);
            int flags = in.readUnsignedByte();
            boolean bl = isKeyframe = (flags & 1) != 0;
            if (onlyDecodeIfKeyframe && !isKeyframe) {
                System.err.println("ZMBVCodec cannot decode delta without preceeding keyframe.");
                return 0;
            }
            if (isKeyframe) {
                this.majorVersion = in.readUnsignedByte();
                this.minorVersion = in.readUnsignedByte();
                this.compressionType = in.readUnsignedByte();
                this.videoFormat = in.readUnsignedByte();
                this.blockWidth = in.readUnsignedByte();
                this.blockHeight = in.readUnsignedByte();
            }
            if (this.majorVersion != 0 || this.minorVersion != 1) {
                System.err.println("unsupported version " + this.majorVersion + "." + this.minorVersion);
                return 0;
            }
            switch (this.compressionType) {
                case 1: {
                    if (!isKeyframe && this.inflaterInputStream != null) {
                        AppendableByteArrayInputStream bais = this.byteArrayInputStream;
                        bais.appendBuffer(inDat, (int)in.getStreamPosition() + off, (int)((long)length - in.getStreamPosition()), true);
                    } else {
                        if (this.byteArrayInputStream != null) {
                            this.byteArrayInputStream.setBuffer(inDat, (int)in.getStreamPosition() + off, (int)((long)length - in.getStreamPosition()));
                        } else {
                            this.byteArrayInputStream = new AppendableByteArrayInputStream((byte[])inDat.clone(), (int)in.getStreamPosition() + off, (int)((long)length - in.getStreamPosition()));
                        }
                        if (this.inflaterInputStream != null) {
                            this.inflaterInputStream.close();
                        }
                        this.inflaterInputStream = new InflaterInputStream(this.byteArrayInputStream);
                    }
                    in = new UncachedImageInputStream(this.inflaterInputStream, ByteOrder.LITTLE_ENDIAN);
                    break;
                }
                case 0: {
                    System.err.println(" NO COMPRESSION");
                    return 0;
                }
                default: {
                    System.err.println("unsupported compression type " + this.compressionType);
                    return 0;
                }
            }
            switch (this.videoFormat) {
                case 4: {
                    depth = 8;
                    if (!(outDatHolder[0] instanceof byte[])) {
                        outDatHolder[0] = new byte[width * height];
                    }
                    if (!(prevDatHolder[0] instanceof byte[])) {
                        prevDatHolder[0] = new byte[width * height];
                    }
                    this.decode8to8(in, (byte[])outDatHolder[0], (byte[])prevDatHolder[0], flags, width, height);
                    break;
                }
                case 5: {
                    depth = 15;
                    if (!(outDatHolder[0] instanceof short[])) {
                        outDatHolder[0] = new short[width * height];
                    }
                    if (!(prevDatHolder[0] instanceof short[])) {
                        prevDatHolder[0] = new short[width * height];
                    }
                    this.decode15to15(in, (short[])outDatHolder[0], (short[])prevDatHolder[0], flags, width, height);
                    break;
                }
                case 6: {
                    depth = 16;
                    if (!(outDatHolder[0] instanceof short[])) {
                        outDatHolder[0] = new short[width * height];
                    }
                    if (!(prevDatHolder[0] instanceof short[])) {
                        prevDatHolder[0] = new short[width * height];
                    }
                    this.decode16to16(in, (short[])outDatHolder[0], (short[])prevDatHolder[0], flags, width, height);
                    break;
                }
                case 8: {
                    depth = 32;
                    if (!(outDatHolder[0] instanceof int[])) {
                        outDatHolder[0] = new short[width * height];
                    }
                    if (!(prevDatHolder[0] instanceof int[])) {
                        prevDatHolder[0] = new short[width * height];
                    }
                    this.decode32to32(in, (int[])outDatHolder[0], (int[])prevDatHolder[0], flags, width, height);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported video format " + this.videoFormat);
                }
            }
        }
        catch (IOException ex) {
            System.err.println("ZMBVCodecCore decoding, isKeyframe=" + isKeyframe);
            ex.printStackTrace();
        }
        if (isKeyframe) {
            n = -depth;
            return n;
        }
        n = depth;
        return n;
    }

    private void decode8to32(ImageInputStream in, int[] outDat, int[] prevDat, int flags, int width, int height) throws IOException {
        boolean isPaletteChange;
        boolean isKeyframe = (flags & 1) != 0;
        boolean bl = isPaletteChange = (flags & 2) != 0;
        if (this.palette == null) {
            this.palette = new int[256];
        }
        int blockSize = this.blockWidth * this.blockHeight;
        if (this.blockDataBuf == null || this.blockDataBuf.length < Math.max(3, blockSize)) {
            this.blockDataBuf = new byte[Math.max(3, blockSize)];
        }
        byte[] buf = this.blockDataBuf;
        if (isKeyframe) {
            int i = 0;
            while (i < 256) {
                in.readFully(buf, 0, 3);
                this.palette[i] = buf[2] & 0xFF | (buf[1] & 0xFF) << 8 | (buf[0] & 0xFF) << 16 | i << 24;
                ++i;
            }
            i = 0;
            int n = width * height;
            while (i < n) {
                outDat[i] = this.palette[in.readUnsignedByte()];
                ++i;
            }
        } else {
            if (isPaletteChange) {
                int i = 0;
                while (i < 256) {
                    in.readFully(buf, 0, 3);
                    int n = i++;
                    this.palette[n] = this.palette[n] ^ (buf[2] & 0xFF | (buf[1] & 0xFF) << 8 | (buf[0] & 0xFF) << 16);
                }
            }
            int nbx = (width + this.blockWidth - 1) / this.blockWidth;
            int nby = (height + this.blockHeight - 1) / this.blockHeight;
            int blockHeaderSize = nbx * nby * 2 + 3 & 0xFFFFFFFC;
            if (this.blockHeaderBuf == null || this.blockHeaderBuf.length < blockHeaderSize) {
                this.blockHeaderBuf = new byte[blockHeaderSize];
            }
            byte[] blocks = this.blockHeaderBuf;
            in.readFully(blocks, 0, blockHeaderSize);
            int block = 0;
            int by = 0;
            while (by < height) {
                int bh2 = Math.min(height - by, this.blockHeight);
                int bx = 0;
                while (bx < width) {
                    int bw2 = Math.min(width - bx, this.blockWidth);
                    byte a = blocks[block++];
                    byte b = blocks[block++];
                    int dx = a >> 1;
                    int dy = b >> 1;
                    int flag = a & 1;
                    if (flag == 0) {
                        int y = 0;
                        while (y < bh2) {
                            int x;
                            int py = by + y + dy;
                            int iout = bx + (by + y) * width;
                            if (py < 0 || height <= py) {
                                x = 0;
                                while (x < bw2) {
                                    outDat[iout++] = this.palette[0];
                                    ++x;
                                }
                            } else {
                                x = 0;
                                while (x < bw2) {
                                    int px = bx + x + dx;
                                    outDat[iout++] = px >= 0 && px < width ? this.palette[prevDat[px + py * width] >>> 24] : this.palette[0];
                                    ++x;
                                }
                            }
                            ++y;
                        }
                    } else {
                        in.readFully(buf, 0, bw2 * bh2);
                        int iblock = 0;
                        int y = 0;
                        while (y < bh2) {
                            int py = by + y + dy;
                            int iout = bx + (by + y) * width;
                            int x = 0;
                            while (x < bw2) {
                                int px = bx + x + dx;
                                int paletteIndex = buf[iblock++] & 0xFF;
                                if (py >= 0 && py < height && px >= 0 && px < width) {
                                    paletteIndex ^= prevDat[px + py * width] >>> 24;
                                }
                                outDat[iout] = this.palette[paletteIndex];
                                ++iout;
                                ++x;
                            }
                            ++y;
                        }
                    }
                    bx += this.blockWidth;
                }
                by += this.blockHeight;
            }
        }
    }

    private void decode8to8(ImageInputStream in, byte[] outDat, byte[] prevDat, int flags, int width, int height) throws IOException {
        boolean isPaletteChange;
        boolean isKeyframe = (flags & 1) != 0;
        boolean bl = isPaletteChange = (flags & 2) != 0;
        if (this.palette == null) {
            this.palette = new int[256];
        }
        int blockSize = this.blockWidth * this.blockHeight;
        if (this.blockDataBuf == null || this.blockDataBuf.length < Math.max(3, blockSize)) {
            this.blockDataBuf = new byte[Math.max(3, blockSize)];
        }
        byte[] buf = this.blockDataBuf;
        if (isKeyframe) {
            int i = 0;
            while (i < 256) {
                in.readFully(buf, 0, 3);
                this.palette[i] = buf[2] & 0xFF | (buf[1] & 0xFF) << 8 | (buf[0] & 0xFF) << 16 | i << 24;
                ++i;
            }
            i = 0;
            int n = width * height;
            while (i < n) {
                outDat[i] = in.readByte();
                ++i;
            }
        } else {
            if (isPaletteChange) {
                int i = 0;
                while (i < 256) {
                    in.readFully(buf, 0, 3);
                    int n = i++;
                    this.palette[n] = this.palette[n] ^ (buf[2] & 0xFF | (buf[1] & 0xFF) << 8 | (buf[0] & 0xFF) << 16);
                }
            }
            int nbx = (width + this.blockWidth - 1) / this.blockWidth;
            int nby = (height + this.blockHeight - 1) / this.blockHeight;
            int blockHeaderSize = nbx * nby * 2 + 3 & 0xFFFFFFFC;
            if (this.blockHeaderBuf == null || this.blockHeaderBuf.length < blockHeaderSize) {
                this.blockHeaderBuf = new byte[blockHeaderSize];
            }
            byte[] blocks = this.blockHeaderBuf;
            in.readFully(blocks, 0, blockHeaderSize);
            int block = 0;
            int by = 0;
            while (by < height) {
                int bh2 = Math.min(height - by, this.blockHeight);
                int bx = 0;
                while (bx < width) {
                    int bw2 = Math.min(width - bx, this.blockWidth);
                    byte a = blocks[block++];
                    byte b = blocks[block++];
                    int dx = a >> 1;
                    int dy = b >> 1;
                    int flag = a & 1;
                    if (flag == 0) {
                        int y = 0;
                        while (y < bh2) {
                            int x;
                            int py = by + y + dy;
                            int iout = bx + (by + y) * width;
                            if (py < 0 || height <= py) {
                                x = 0;
                                while (x < bw2) {
                                    outDat[iout++] = 0;
                                    ++x;
                                }
                            } else {
                                x = 0;
                                while (x < bw2) {
                                    int px = bx + x + dx;
                                    outDat[iout++] = px >= 0 && px < width ? prevDat[px + py * width] : (byte)0;
                                    ++x;
                                }
                            }
                            ++y;
                        }
                    } else {
                        in.readFully(buf, 0, bw2 * bh2);
                        int iblock = 0;
                        int y = 0;
                        while (y < bh2) {
                            int py = by + y + dy;
                            int iout = bx + (by + y) * width;
                            int x = 0;
                            while (x < bw2) {
                                int px = bx + x + dx;
                                byte paletteIndex = buf[iblock++];
                                if (py >= 0 && py < height && px >= 0 && px < width) {
                                    paletteIndex = (byte)(paletteIndex ^ prevDat[px + py * width]);
                                }
                                outDat[iout] = paletteIndex;
                                ++iout;
                                ++x;
                            }
                            ++y;
                        }
                    }
                    bx += this.blockWidth;
                }
                by += this.blockHeight;
            }
        }
    }

    private void decode15to32(ImageInputStream in, int[] outDat, int[] prevDat, int flags, int width, int height) throws IOException {
        boolean isKeyframe = (flags & 1) != 0;
        int blockSize = this.blockWidth * this.blockHeight;
        if (this.blockDataBuf == null || this.blockDataBuf.length < Math.max(3, blockSize * 2)) {
            this.blockDataBuf = new byte[Math.max(3, blockSize * 2)];
        }
        byte[] buf = this.blockDataBuf;
        if (isKeyframe) {
            int i = 0;
            int n = width * height;
            while (i < n) {
                int bgr = in.readUnsignedShort();
                outDat[i] = (bgr & 0x3E0) << 6 | (bgr & 0x380) << 1 | (bgr & 0x7C00) << 9 | (bgr & 0x7000) << 4 | (bgr & 0x1F) << 3 | (bgr & 0x1C) >>> 2;
                ++i;
            }
        } else {
            int nbx = (width + this.blockWidth - 1) / this.blockWidth;
            int nby = (height + this.blockHeight - 1) / this.blockHeight;
            int blockHeaderSize = nbx * nby * 2 + 3 & 0xFFFFFFFC;
            if (this.blockHeaderBuf == null || this.blockHeaderBuf.length < blockHeaderSize) {
                this.blockHeaderBuf = new byte[blockHeaderSize];
            }
            byte[] blocks = this.blockHeaderBuf;
            in.readFully(blocks, 0, blockHeaderSize);
            int block = 0;
            int by = 0;
            while (by < height) {
                int bh2 = Math.min(height - by, this.blockHeight);
                int bx = 0;
                while (bx < width) {
                    int bw2 = Math.min(width - bx, this.blockWidth);
                    byte a = blocks[block++];
                    byte b = blocks[block++];
                    int dx = a >> 1;
                    int dy = b >> 1;
                    int flag = a & 1;
                    if (flag == 0) {
                        int y = 0;
                        while (y < bh2) {
                            int x;
                            int py = by + y + dy;
                            int iout = bx + (by + y) * width;
                            if (py < 0 || height <= py) {
                                x = 0;
                                while (x < bw2) {
                                    outDat[iout++] = 0;
                                    ++x;
                                }
                            } else {
                                x = 0;
                                while (x < bw2) {
                                    int px = bx + x + dx;
                                    outDat[iout++] = px >= 0 && px < width ? prevDat[px + py * width] : 0;
                                    ++x;
                                }
                            }
                            ++y;
                        }
                    } else {
                        in.readFully(buf, 0, bw2 * bh2 * 2);
                        int iblock = 0;
                        int y = 0;
                        while (y < bh2) {
                            int py = by + y + dy;
                            int iout = bx + (by + y) * width;
                            int x = 0;
                            while (x < bw2) {
                                int px = bx + x + dx;
                                int bgr = buf[iblock++] & 0xFF | (buf[iblock++] & 0xFF) << 8;
                                int rgb = (bgr & 0x3E0) << 6 | (bgr & 0x380) << 1 | (bgr & 0x7C00) << 9 | (bgr & 0x7000) << 4 | (bgr & 0x1F) << 3 | (bgr & 0x1C) >>> 2;
                                if (py >= 0 && py < height && px >= 0 && px < width) {
                                    rgb ^= prevDat[px + py * width];
                                }
                                outDat[iout] = rgb;
                                ++iout;
                                ++x;
                            }
                            ++y;
                        }
                    }
                    bx += this.blockWidth;
                }
                by += this.blockHeight;
            }
        }
    }

    private void decode15to15(ImageInputStream in, short[] outDat, short[] prevDat, int flags, int width, int height) throws IOException {
        boolean isKeyframe = (flags & 1) != 0;
        int blockSize = this.blockWidth * this.blockHeight;
        if (this.blockDataBuf == null || this.blockDataBuf.length < Math.max(3, blockSize * 2)) {
            this.blockDataBuf = new byte[Math.max(3, blockSize * 2)];
        }
        byte[] buf = this.blockDataBuf;
        if (isKeyframe) {
            int i = 0;
            int n = width * height;
            while (i < n) {
                int bgr = in.readUnsignedShort();
                outDat[i] = (short)bgr;
                ++i;
            }
        } else {
            int nbx = (width + this.blockWidth - 1) / this.blockWidth;
            int nby = (height + this.blockHeight - 1) / this.blockHeight;
            int blockHeaderSize = nbx * nby * 2 + 3 & 0xFFFFFFFC;
            if (this.blockHeaderBuf == null || this.blockHeaderBuf.length < blockHeaderSize) {
                this.blockHeaderBuf = new byte[blockHeaderSize];
            }
            byte[] blocks = this.blockHeaderBuf;
            in.readFully(blocks, 0, blockHeaderSize);
            int block = 0;
            int by = 0;
            while (by < height) {
                int bh2 = Math.min(height - by, this.blockHeight);
                int bx = 0;
                while (bx < width) {
                    int bw2 = Math.min(width - bx, this.blockWidth);
                    byte a = blocks[block++];
                    byte b = blocks[block++];
                    int dx = a >> 1;
                    int dy = b >> 1;
                    int flag = a & 1;
                    if (flag == 0) {
                        int y = 0;
                        while (y < bh2) {
                            int x;
                            int py = by + y + dy;
                            int iout = bx + (by + y) * width;
                            if (py < 0 || height <= py) {
                                x = 0;
                                while (x < bw2) {
                                    outDat[iout++] = 0;
                                    ++x;
                                }
                            } else {
                                x = 0;
                                while (x < bw2) {
                                    int px = bx + x + dx;
                                    outDat[iout++] = px >= 0 && px < width ? prevDat[px + py * width] : (short)0;
                                    ++x;
                                }
                            }
                            ++y;
                        }
                    } else {
                        in.readFully(buf, 0, bw2 * bh2 * 2);
                        int iblock = 0;
                        int y = 0;
                        while (y < bh2) {
                            int py = by + y + dy;
                            int iout = bx + (by + y) * width;
                            int x = 0;
                            while (x < bw2) {
                                int px = bx + x + dx;
                                int bgr = buf[iblock++] & 0xFF | (buf[iblock++] & 0xFF) << 8;
                                if (py >= 0 && py < height && px >= 0 && px < width) {
                                    bgr ^= prevDat[px + py * width];
                                }
                                outDat[iout] = (short)bgr;
                                ++iout;
                                ++x;
                            }
                            ++y;
                        }
                    }
                    bx += this.blockWidth;
                }
                by += this.blockHeight;
            }
        }
    }

    private void decode16to32(ImageInputStream in, int[] outDat, int[] prevDat, int flags, int width, int height) throws IOException {
        boolean isKeyframe = (flags & 1) != 0;
        int blockSize = this.blockWidth * this.blockHeight;
        if (this.blockDataBuf == null || this.blockDataBuf.length < Math.max(3, blockSize * 2)) {
            this.blockDataBuf = new byte[Math.max(3, blockSize * 2)];
        }
        byte[] buf = this.blockDataBuf;
        if (isKeyframe) {
            int i = 0;
            int n = width * height;
            while (i < n) {
                int bgr = in.readUnsignedShort();
                outDat[i] = (bgr & 0x7E0) << 5 | (bgr & 0x600) >> 1 | (bgr & 0xF800) << 8 | (bgr & 0xE000) << 3 | (bgr & 0x1F) << 3 | (bgr & 0x1C) >>> 2;
                ++i;
            }
        } else {
            int nbx = (width + this.blockWidth - 1) / this.blockWidth;
            int nby = (height + this.blockHeight - 1) / this.blockHeight;
            int blockHeaderSize = nbx * nby * 2 + 3 & 0xFFFFFFFC;
            if (this.blockHeaderBuf == null || this.blockHeaderBuf.length < blockHeaderSize) {
                this.blockHeaderBuf = new byte[blockHeaderSize];
            }
            byte[] blocks = this.blockHeaderBuf;
            in.readFully(blocks, 0, blockHeaderSize);
            int block = 0;
            int by = 0;
            while (by < height) {
                int bh2 = Math.min(height - by, this.blockHeight);
                int bx = 0;
                while (bx < width) {
                    int bw2 = Math.min(width - bx, this.blockWidth);
                    byte a = blocks[block++];
                    byte b = blocks[block++];
                    int dx = a >> 1;
                    int dy = b >> 1;
                    int flag = a & 1;
                    if (flag == 0) {
                        int y = 0;
                        while (y < bh2) {
                            int py = by + y + dy;
                            int iout = bx + (by + y) * width;
                            int x = 0;
                            while (x < bw2) {
                                int px = bx + x + dx;
                                outDat[iout] = py >= 0 && py < height && px >= 0 && px < width ? prevDat[px + py * width] : 0;
                                ++iout;
                                ++x;
                            }
                            ++y;
                        }
                    } else {
                        in.readFully(buf, 0, bw2 * bh2 * 2);
                        int iblock = 0;
                        int y = 0;
                        while (y < bh2) {
                            int py = by + y + dy;
                            int iout = bx + (by + y) * width;
                            int x = 0;
                            while (x < bw2) {
                                int px = bx + x + dx;
                                int bgr = buf[iblock++] & 0xFF | (buf[iblock++] & 0xFF) << 8;
                                int rgb = (bgr & 0x7E0) << 5 | (bgr & 0x600) >> 1 | (bgr & 0xF800) << 8 | (bgr & 0xE000) << 3 | (bgr & 0x1F) << 3 | (bgr & 0x1C) >>> 2;
                                if (py >= 0 && py < height && px >= 0 && px < width) {
                                    rgb ^= prevDat[px + py * width];
                                }
                                outDat[iout] = (short)bgr;
                                ++iout;
                                ++x;
                            }
                            ++y;
                        }
                    }
                    bx += this.blockWidth;
                }
                by += this.blockHeight;
            }
        }
    }

    private void decode16to16(ImageInputStream in, short[] outDat, short[] prevDat, int flags, int width, int height) throws IOException {
        boolean isKeyframe = (flags & 1) != 0;
        int blockSize = this.blockWidth * this.blockHeight;
        if (this.blockDataBuf == null || this.blockDataBuf.length < Math.max(3, blockSize * 2)) {
            this.blockDataBuf = new byte[Math.max(3, blockSize * 2)];
        }
        byte[] buf = this.blockDataBuf;
        if (isKeyframe) {
            int i = 0;
            int n = width * height;
            while (i < n) {
                int bgr = in.readUnsignedShort();
                outDat[i] = (short)bgr;
                ++i;
            }
        } else {
            int nbx = (width + this.blockWidth - 1) / this.blockWidth;
            int nby = (height + this.blockHeight - 1) / this.blockHeight;
            int blockHeaderSize = nbx * nby * 2 + 3 & 0xFFFFFFFC;
            if (this.blockHeaderBuf == null || this.blockHeaderBuf.length < blockHeaderSize) {
                this.blockHeaderBuf = new byte[blockHeaderSize];
            }
            byte[] blocks = this.blockHeaderBuf;
            in.readFully(blocks, 0, blockHeaderSize);
            int block = 0;
            int by = 0;
            while (by < height) {
                int bh2 = Math.min(height - by, this.blockHeight);
                int bx = 0;
                while (bx < width) {
                    int bw2 = Math.min(width - bx, this.blockWidth);
                    byte a = blocks[block++];
                    byte b = blocks[block++];
                    int dx = a >> 1;
                    int dy = b >> 1;
                    int flag = a & 1;
                    if (flag == 0) {
                        int y = 0;
                        while (y < bh2) {
                            int py = by + y + dy;
                            int iout = bx + (by + y) * width;
                            int x = 0;
                            while (x < bw2) {
                                int px = bx + x + dx;
                                outDat[iout] = py >= 0 && py < height && px >= 0 && px < width ? prevDat[px + py * width] : (short)0;
                                ++iout;
                                ++x;
                            }
                            ++y;
                        }
                    } else {
                        in.readFully(buf, 0, bw2 * bh2 * 2);
                        int iblock = 0;
                        int y = 0;
                        while (y < bh2) {
                            int py = by + y + dy;
                            int iout = bx + (by + y) * width;
                            int x = 0;
                            while (x < bw2) {
                                int px = bx + x + dx;
                                int bgr = buf[iblock++] & 0xFF | (buf[iblock++] & 0xFF) << 8;
                                if (py >= 0 && py < height && px >= 0 && px < width) {
                                    bgr ^= prevDat[px + py * width];
                                }
                                outDat[iout] = (short)bgr;
                                ++iout;
                                ++x;
                            }
                            ++y;
                        }
                    }
                    bx += this.blockWidth;
                }
                by += this.blockHeight;
            }
        }
    }

    private void decode32to32(ImageInputStream in, int[] outDat, int[] prevDat, int flags, int width, int height) throws IOException {
        boolean isKeyframe = (flags & 1) != 0;
        int blockSize = this.blockWidth * this.blockHeight;
        if (this.blockDataBuf == null || this.blockDataBuf.length < Math.max(3, blockSize * 4)) {
            this.blockDataBuf = new byte[Math.max(3, blockSize * 4)];
        }
        byte[] buf = this.blockDataBuf;
        if (isKeyframe) {
            int i = 0;
            int n = width * height;
            while (i < n) {
                int bgr;
                outDat[i] = bgr = in.readInt();
                ++i;
            }
        } else {
            int nbx = (width + this.blockWidth - 1) / this.blockWidth;
            int nby = (height + this.blockHeight - 1) / this.blockHeight;
            int blockHeaderSize = nbx * nby * 2 + 3 & 0xFFFFFFFC;
            if (this.blockHeaderBuf == null || this.blockHeaderBuf.length < blockHeaderSize) {
                this.blockHeaderBuf = new byte[blockHeaderSize];
            }
            byte[] blocks = this.blockHeaderBuf;
            in.readFully(blocks, 0, blockHeaderSize);
            int block = 0;
            int by = 0;
            while (by < height) {
                int bh2 = Math.min(height - by, this.blockHeight);
                int bx = 0;
                while (bx < width) {
                    int bw2 = Math.min(width - bx, this.blockWidth);
                    byte a = blocks[block++];
                    byte b = blocks[block++];
                    int dx = a >> 1;
                    int dy = b >> 1;
                    int flag = a & 1;
                    if (flag == 0) {
                        int y = 0;
                        while (y < bh2) {
                            int py = by + y + dy;
                            int iout = bx + (by + y) * width;
                            int x = 0;
                            while (x < bw2) {
                                int px = bx + x + dx;
                                int rgb = py >= 0 && py < height && px >= 0 && px < width ? prevDat[px + py * width] : 0;
                                outDat[iout] = rgb;
                                ++iout;
                                ++x;
                            }
                            ++y;
                        }
                    } else {
                        in.readFully(buf, 0, bw2 * bh2 * 4);
                        int iblock = 0;
                        int y = 0;
                        while (y < bh2) {
                            int py = by + y + dy;
                            int iout = bx + (by + y) * width;
                            int x = 0;
                            while (x < bw2) {
                                int px = bx + x + dx;
                                int bgr = buf[iblock] & 0xFF | (buf[iblock + 1] & 0xFF) << 8 | (buf[iblock + 2] & 0xFF) << 16 | (buf[iblock + 3] & 0xFF) << 24;
                                iblock += 4;
                                int rgb = bgr;
                                if (py >= 0 && py < height && px >= 0 && px < width) {
                                    rgb ^= prevDat[px + py * width];
                                }
                                outDat[iout] = rgb;
                                ++iout;
                                ++x;
                            }
                            ++y;
                        }
                    }
                    bx += this.blockWidth;
                }
                by += this.blockHeight;
            }
        }
    }

    public int[] getPalette() {
        if (this.palette == null) {
            this.palette = new int[256];
            int i = 0;
            while (i < this.palette.length) {
                this.palette[i] = i | i << 8 | i << 16;
                ++i;
            }
        }
        return this.palette;
    }
}

