/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.avi;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import javax.imageio.stream.ImageOutputStream;
import org.monte.media.AbstractVideoCodec;
import org.monte.media.Buffer;
import org.monte.media.BufferFlag;
import org.monte.media.Format;
import org.monte.media.FormatKeys;
import org.monte.media.VideoFormatKeys;
import org.monte.media.io.ByteArrayImageOutputStream;

public class RunLengthCodec
extends AbstractVideoCodec {
    private byte[] previousPixels;
    private int frameCounter;

    public RunLengthCodec() {
        super(new Format[]{new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "Java", FormatKeys.EncodingKey, "image", VideoFormatKeys.FixedFrameRateKey, true})}, new Format[]{new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "video/avi", FormatKeys.EncodingKey, "RLE ", VideoFormatKeys.DataClassKey, byte[].class, VideoFormatKeys.FixedFrameRateKey, true, VideoFormatKeys.DepthKey, 8})});
    }

    @Override
    public void reset() {
        this.frameCounter = 0;
    }

    @Override
    public int process(Buffer in, Buffer out) {
        if (this.outputFormat == null) {
            return 1;
        }
        if (this.outputFormat.get(FormatKeys.EncodingKey).equals("RLE ")) {
            return this.encode(in, out);
        }
        return this.decode(in, out);
    }

    private int encode(Buffer in, Buffer out) {
        byte[] pixels;
        boolean isKeyframe;
        int offset;
        Rectangle r;
        int scanlineStride;
        ByteArrayImageOutputStream tmp;
        block10: {
            out.setMetaTo(in);
            out.format = this.outputFormat;
            if (in.isFlag(BufferFlag.DISCARD)) {
                return 0;
            }
            tmp = out.data instanceof byte[] ? new ByteArrayImageOutputStream((byte[])out.data) : new ByteArrayImageOutputStream();
            if (in.data instanceof BufferedImage) {
                BufferedImage image = (BufferedImage)in.data;
                WritableRaster raster = image.getRaster();
                scanlineStride = raster.getSampleModel().getWidth();
                r = raster.getBounds();
                r.x -= raster.getSampleModelTranslateX();
                r.y -= raster.getSampleModelTranslateY();
                out.header = image.getColorModel();
            } else {
                r = new Rectangle(0, 0, this.outputFormat.get(VideoFormatKeys.WidthKey), this.outputFormat.get(VideoFormatKeys.HeightKey));
                scanlineStride = this.outputFormat.get(VideoFormatKeys.WidthKey);
                out.header = null;
            }
            offset = r.x + r.y * scanlineStride;
            isKeyframe = this.frameCounter == 0 || this.frameCounter % this.outputFormat.get(FormatKeys.KeyFrameIntervalKey, this.outputFormat.get(FormatKeys.FrameRateKey).intValue()) == 0;
            ++this.frameCounter;
            try {
                pixels = this.getIndexed8(in);
                if (pixels != null) break block10;
                return 1;
            }
            catch (IOException ex) {
                ex.printStackTrace();
                out.setFlag(BufferFlag.DISCARD);
                return 1;
            }
        }
        if (isKeyframe) {
            this.writeKey8(tmp, pixels, r.width, r.height, offset, scanlineStride);
            out.setFlag(BufferFlag.KEYFRAME);
        } else {
            this.writeDelta8(tmp, pixels, this.previousPixels, r.width, r.height, offset, scanlineStride);
            out.clearFlag(BufferFlag.KEYFRAME);
        }
        out.data = tmp.getBuffer();
        out.offset = 0;
        out.length = (int)tmp.getStreamPosition();
        if (this.previousPixels == null) {
            this.previousPixels = (byte[])pixels.clone();
        } else {
            System.arraycopy(pixels, 0, this.previousPixels, 0, pixels.length);
        }
        return 0;
    }

    private int decode(Buffer in, Buffer out) {
        return 1;
    }

    public void writeKey8(OutputStream out, byte[] data, int width, int height, int offset, int scanlineStride) throws IOException {
        ByteArrayImageOutputStream buf = new ByteArrayImageOutputStream(data.length);
        this.writeKey8(buf, data, width, height, offset, scanlineStride);
        buf.toOutputStream(out);
    }

    public void writeKey8(ImageOutputStream out, byte[] data, int width, int height, int offset, int scanlineStride) throws IOException {
        out.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        int ymax = offset + height * scanlineStride;
        int upsideDown = ymax - scanlineStride + offset;
        int y = offset;
        while (y < ymax) {
            int xy = upsideDown - y;
            int xymax = xy + width;
            int literalCount = 0;
            int repeatCount = 0;
            while (xy < xymax) {
                byte v = data[xy];
                repeatCount = 0;
                while (xy < xymax && repeatCount < 255) {
                    if (data[xy] != v) break;
                    ++xy;
                    ++repeatCount;
                }
                xy -= repeatCount;
                if (repeatCount < 3) {
                    if (++literalCount == 254) {
                        out.write(0);
                        out.write(literalCount);
                        out.write(data, xy - literalCount + 1, literalCount);
                        literalCount = 0;
                    }
                } else {
                    if (literalCount > 0) {
                        if (literalCount < 3) {
                            while (literalCount > 0) {
                                out.write(1);
                                out.write(data[xy - literalCount]);
                                --literalCount;
                            }
                        } else {
                            out.write(0);
                            out.write(literalCount);
                            out.write(data, xy - literalCount, literalCount);
                            if (literalCount % 2 == 1) {
                                out.write(0);
                            }
                            literalCount = 0;
                        }
                    }
                    out.write(repeatCount);
                    out.write(v);
                    xy += repeatCount - 1;
                }
                ++xy;
            }
            if (literalCount > 0) {
                if (literalCount < 3) {
                    while (literalCount > 0) {
                        out.write(1);
                        out.write(data[xy - literalCount]);
                        --literalCount;
                    }
                } else {
                    out.write(0);
                    out.write(literalCount);
                    out.write(data, xy - literalCount, literalCount);
                    if (literalCount % 2 == 1) {
                        out.write(0);
                    }
                }
                literalCount = 0;
            }
            out.write(0);
            out.write(0);
            y += scanlineStride;
        }
        out.write(0);
        out.write(1);
    }

    public void writeDelta8(OutputStream out, byte[] data, byte[] prev, int width, int height, int offset, int scanlineStride) throws IOException {
        ByteArrayImageOutputStream buf = new ByteArrayImageOutputStream(data.length);
        this.writeDelta8(buf, data, prev, width, height, offset, scanlineStride);
        buf.toOutputStream(out);
    }

    /*
     * Unable to fully structure code
     */
    public void writeDelta8(ImageOutputStream out, byte[] data, byte[] prev, int width, int height, int offset, int scanlineStride) throws IOException {
        out.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        ymax = offset + height * scanlineStride;
        upsideDown = ymax - scanlineStride + offset;
        verticalOffset = 0;
        y = offset;
        while (y < ymax) {
            block18: {
                xy = upsideDown - y;
                xymax = xy + width;
                skipCount = 0;
                while (xy < xymax) {
                    if (data[xy] != prev[xy]) break;
                    ++xy;
                    ++skipCount;
                }
                if (skipCount != width) ** GOTO lbl29
                ++verticalOffset;
                break block18;
lbl-1000:
                // 1 sources

                {
                    if (verticalOffset == 1 && skipCount == 0) {
                        out.write(0);
                        out.write(0);
                        verticalOffset = 0;
                        continue;
                    }
                    out.write(0);
                    out.write(2);
                    out.write(Math.min(255, skipCount));
                    out.write(Math.min(255, verticalOffset));
                    skipCount -= Math.min(255, skipCount);
                    verticalOffset -= Math.min(255, verticalOffset);
lbl29:
                    // 3 sources

                    ** while (verticalOffset > 0 || skipCount > 0)
                }
lbl30:
                // 1 sources

                literalCount = 0;
                repeatCount = 0;
                while (xy < xymax) {
                    block19: {
                        skipCount = 0;
                        while (xy < xymax) {
                            if (data[xy] != prev[xy]) break;
                            ++xy;
                            ++skipCount;
                        }
                        v = data[xy -= skipCount];
                        repeatCount = 0;
                        while (xy < xymax && repeatCount < 255) {
                            if (data[xy] != v) break;
                            ++xy;
                            ++repeatCount;
                        }
                        if (skipCount >= 4 || (xy -= repeatCount) + skipCount >= xymax || repeatCount >= 3) ** GOTO lbl61
                        ++literalCount;
                        break block19;
lbl-1000:
                        // 1 sources

                        {
                            if (literalCount < 3) {
                                out.write(1);
                                out.write(data[xy - literalCount]);
                                --literalCount;
                                continue;
                            }
                            literalRun = Math.min(254, literalCount);
                            out.write(0);
                            out.write(literalRun);
                            out.write(data, xy - literalCount, literalRun);
                            if (literalRun % 2 == 1) {
                                out.write(0);
                            }
                            literalCount -= literalRun;
lbl61:
                            // 3 sources

                            ** while (literalCount > 0)
                        }
lbl62:
                        // 1 sources

                        if (xy + skipCount == xymax) {
                            xy += skipCount - 1;
                        } else if (skipCount >= repeatCount) {
                            while (skipCount > 0) {
                                out.write(0);
                                out.write(2);
                                out.write(Math.min(255, skipCount));
                                out.write(0);
                                xy += Math.min(255, skipCount);
                                skipCount -= Math.min(255, skipCount);
                            }
                            --xy;
                        } else {
                            out.write(repeatCount);
                            out.write(v);
                            xy += repeatCount - 1;
                        }
                    }
                    ++xy;
                }
                while (literalCount > 0) {
                    if (literalCount < 3) {
                        out.write(1);
                        out.write(data[xy - literalCount]);
                        --literalCount;
                        continue;
                    }
                    literalRun = Math.min(254, literalCount);
                    out.write(0);
                    out.write(literalRun);
                    out.write(data, xy - literalCount, literalRun);
                    if (literalRun % 2 == 1) {
                        out.write(0);
                    }
                    literalCount -= literalRun;
                }
                out.write(0);
                out.write(0);
            }
            y += scanlineStride;
        }
        out.write(0);
        out.write(1);
    }
}

