/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.anim;

import java.awt.image.BufferedImage;
import org.monte.media.AbstractVideoCodec;
import org.monte.media.Buffer;
import org.monte.media.BufferFlag;
import org.monte.media.Format;
import org.monte.media.FormatKeys;
import org.monte.media.VideoFormatKeys;
import org.monte.media.image.BitmapImage;

public class BitmapCodec
extends AbstractVideoCodec {
    public BitmapCodec() {
        super(new Format[]{new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "x-iff/anim", FormatKeys.EncodingKey, "op5", VideoFormatKeys.DataClassKey, byte[].class, VideoFormatKeys.FixedFrameRateKey, false})}, new Format[]{new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "Java", FormatKeys.EncodingKey, "image", VideoFormatKeys.FixedFrameRateKey, false})});
        this.name = "ILBM Codec";
    }

    @Override
    public int process(Buffer in, Buffer out) {
        BitmapImage bitmap;
        out.setMetaTo(in);
        if (in.isFlag(BufferFlag.DISCARD)) {
            return 0;
        }
        out.format = this.outputFormat;
        BufferedImage pixmap = (BufferedImage)in.data;
        Format vf = this.outputFormat;
        BitmapImage bitmapImage = bitmap = out.data instanceof BitmapImage ? (BitmapImage)out.data : null;
        if (bitmap == null || bitmap.getWidth() != vf.get(VideoFormatKeys.WidthKey).intValue() || bitmap.getHeight() != vf.get(VideoFormatKeys.HeightKey).intValue() || bitmap.getDepth() != vf.get(VideoFormatKeys.DepthKey).intValue()) {
            bitmap = new BitmapImage(vf.get(VideoFormatKeys.WidthKey), vf.get(VideoFormatKeys.HeightKey), vf.get(VideoFormatKeys.DepthKey), pixmap.getColorModel());
            out.data = bitmap;
        }
        bitmap.setPlanarColorModel(pixmap.getColorModel());
        bitmap.convertFromChunky(pixmap);
        return 0;
    }
}

