/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.anim;

import org.monte.media.ParseException;
import org.monte.media.anim.ANIMFrame;
import org.monte.media.anim.ANIMMovieTrack;
import org.monte.media.iff.IFFParser;
import org.monte.media.image.BitmapImage;

public class ANIMKeyFrame
extends ANIMFrame {
    private int compression;
    protected static final int VDAT_ID = IFFParser.stringToID("VDAT");

    @Override
    public void setData(byte[] data) {
        this.data = data;
    }

    public void setCompression(int compression) {
        this.compression = compression;
    }

    @Override
    public void decode(BitmapImage bitmap, ANIMMovieTrack track) {
        switch (this.compression) {
            case 1: {
                ANIMKeyFrame.unpackByteRun1(this.data, bitmap.getBitmap());
                break;
            }
            case 2: {
                this.unpackVertical(this.data, bitmap);
                break;
            }
            default: {
                System.arraycopy(this.data, 0, bitmap.getBitmap(), 0, this.data.length);
            }
        }
    }

    public static int unpackByteRun1(byte[] in, byte[] out) {
        int iOut = 0;
        int iIn = 0;
        int n = 0;
        try {
            while (iOut < out.length) {
                if ((n = in[iIn++]) >= 0) {
                    System.arraycopy(in, iIn, out, iOut, ++n);
                    iOut += n;
                    iIn += n;
                    continue;
                }
                if (n == -128) continue;
                byte copyByte = in[iIn++];
                while (n < 1) {
                    out[iOut++] = copyByte;
                    ++n;
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            System.out.println("ANIMKeyFrame.unpackByteRun1(): " + e);
            System.out.println("  Plane-Index: " + iOut + " Plane size:" + out.length);
            System.out.println("  Buffer-Index: " + iIn + " Buffer size:" + in.length);
            System.out.println("  Command: " + n);
        }
        return iOut;
    }

    public void unpackVertical(byte[] in, BitmapImage bm) {
        byte[] out = bm.getBitmap();
        int iIn = 0;
        int endOfData = 0;
        int bmhdWidth = bm.getWidth();
        int bmhdHeight = bm.getHeight();
        int bmhdNbPlanes = bm.getDepth();
        byte[] buf = new byte[bmhdWidth * bmhdHeight / 8];
        int scanlineStride = bm.getScanlineStride();
        int columnCount = bmhdWidth / 8 * bmhdHeight;
        int columnStride = bmhdHeight * 2;
        try {
            int p = 0;
            while (p < bmhdNbPlanes) {
                long length;
                int id;
                int iBuf = 0;
                iIn = endOfData;
                if ((id = (in[iIn++] & 0xFF) << 24 | (in[iIn++] & 0xFF) << 16 | (in[iIn++] & 0xFF) << 8 | in[iIn++] & 0xFF) != VDAT_ID) {
                    throw new ParseException("Illegal VDAT chunk ID:" + IFFParser.idToString(id) + " at " + (iIn - 4));
                }
                if ((long)iIn + (length = ((long)in[iIn++] & 0xFFL) << 24 | ((long)in[iIn++] & 0xFFL) << 16 | ((long)in[iIn++] & 0xFFL) << 8 | (long)in[iIn++] & 0xFFL) > (long)in.length) {
                    throw new ParseException("Illegal VDAT chunk length:" + length + " at " + (iIn - 4));
                }
                endOfData = (int)((long)endOfData + (length + 8L));
                int cnt = (in[iIn++] & 0xFF) << 8 | in[iIn++] & 0xFF;
                int iCmd = iIn;
                iIn = iIn + cnt - 2;
                try {
                    int i = cnt - 2;
                    while (i > 0 && iIn < endOfData) {
                        int n;
                        int cmd;
                        if ((cmd = in[iCmd++]) == 0) {
                            n = (in[iIn++] & 0xFF) << 8 | in[iIn++] & 0xFF;
                            n *= 2;
                            while (n > 0) {
                                buf[iBuf++] = in[iIn++];
                                --n;
                            }
                        } else if (cmd == 1) {
                            n = (in[iIn++] & 0xFF) << 8 | in[iIn++] & 0xFF;
                            byte dhigh = in[iIn++];
                            byte dlow = in[iIn++];
                            while (n > 0) {
                                buf[iBuf++] = dhigh;
                                buf[iBuf++] = dlow;
                                --n;
                            }
                        } else if (cmd >= 2) {
                            byte dhigh = in[iIn++];
                            byte dlow = in[iIn++];
                            int n2 = cmd;
                            while (n2 > 0) {
                                buf[iBuf++] = dhigh;
                                buf[iBuf++] = dlow;
                                --n2;
                            }
                        } else {
                            n = cmd * -2;
                            while (n > 0) {
                                buf[iBuf++] = in[iIn++];
                                --n;
                            }
                        }
                        --i;
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    System.err.println("IndexOutOfBounds in bitplane " + p);
                    e.printStackTrace();
                }
                int bitplaneOffset = bm.getBitplaneStride() * p;
                int xBuf = 0;
                int xOut = 0;
                while (xBuf < columnCount) {
                    int yBuf = 0;
                    int yOut = bitplaneOffset;
                    while (yBuf < columnStride) {
                        out[xOut + yOut] = buf[xBuf + yBuf];
                        out[xOut + 1 + yOut] = buf[xBuf + 1 + yBuf];
                        yBuf += 2;
                        yOut += scanlineStride;
                    }
                    xBuf += columnStride;
                    xOut += 2;
                }
                ++p;
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
    }
}

