/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media;

import java.util.ArrayList;
import org.monte.media.Codec;
import org.monte.media.Format;

public abstract class AbstractCodec
implements Codec {
    protected Format[] inputFormats;
    protected Format[] outputFormats;
    protected Format inputFormat;
    protected Format outputFormat;
    protected String name = "unnamed codec";

    public AbstractCodec(Format[] supportedInputFormats, Format[] supportedOutputFormats) {
        this.inputFormats = supportedInputFormats;
        this.outputFormats = supportedOutputFormats;
    }

    public AbstractCodec(Format[] supportedInputOutputFormats) {
        this.inputFormats = supportedInputOutputFormats;
        this.outputFormats = supportedInputOutputFormats;
    }

    @Override
    public Format[] getInputFormats() {
        return (Format[])this.inputFormats.clone();
    }

    @Override
    public Format[] getOutputFormats(Format input) {
        ArrayList<Format> of = new ArrayList<Format>(this.outputFormats.length);
        Format[] formatArray = this.outputFormats;
        int n = this.outputFormats.length;
        int n2 = 0;
        while (n2 < n) {
            Format f = formatArray[n2];
            of.add(input == null ? f : f.append(input));
            ++n2;
        }
        return of.toArray(new Format[of.size()]);
    }

    @Override
    public Format setInputFormat(Format f) {
        if (f != null) {
            Format[] formatArray = this.getInputFormats();
            int n = formatArray.length;
            int n2 = 0;
            while (n2 < n) {
                Format sf = formatArray[n2];
                if (sf.matches(f)) {
                    this.inputFormat = sf.append(f);
                    return this.inputFormat;
                }
                ++n2;
            }
        }
        this.inputFormat = null;
        return null;
    }

    @Override
    public Format setOutputFormat(Format f) {
        Format[] formatArray = this.getOutputFormats(f);
        int n = formatArray.length;
        int n2 = 0;
        while (n2 < n) {
            Format sf = formatArray[n2];
            if (sf.matches(f)) {
                this.outputFormat = f;
                return sf;
            }
            ++n2;
        }
        this.outputFormat = null;
        return null;
    }

    @Override
    public Format getInputFormat() {
        return this.inputFormat;
    }

    @Override
    public Format getOutputFormat() {
        return this.outputFormat;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void reset() {
    }

    public String toString() {
        String className = this.getClass().getName();
        int p = className.lastIndexOf(46);
        return String.valueOf(className.substring(p + 1)) + "{" + "inputFormat=" + this.inputFormat + ", outputFormat=" + this.outputFormat + '}';
    }
}

