/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.iconloader.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class AsyncByteArrayOutputStream
extends OutputStream {
    protected byte[] myBuffer;
    protected int myCount;

    public AsyncByteArrayOutputStream() {
        this(32);
    }

    public AsyncByteArrayOutputStream(int size) {
        this.myBuffer = new byte[size];
    }

    @Override
    public void write(int b) {
        int count = this.myCount + 1;
        if (count > this.myBuffer.length) {
            this.myBuffer = Arrays.copyOf(this.myBuffer, Math.max(this.myBuffer.length << 1, count));
        }
        this.myBuffer[this.myCount] = (byte)b;
        this.myCount = count;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int count = this.myCount + len;
        if (count > this.myBuffer.length) {
            this.myBuffer = Arrays.copyOf(this.myBuffer, Math.max(this.myBuffer.length << 1, count));
        }
        System.arraycopy(b, off, this.myBuffer, this.myCount, len);
        this.myCount = count;
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.myBuffer, 0, this.myCount);
    }

    public void reset() {
        this.myCount = 0;
    }

    public byte[] toByteArray() {
        return Arrays.copyOf(this.myBuffer, this.myCount);
    }

    public int size() {
        return this.myCount;
    }

    public String toString() {
        return new String(this.myBuffer, 0, this.myCount);
    }
}

