/*
 * Decompiled with CFR 0.152.
 */
package com.graphbuilder.math;

public final class PascalsTriangle {
    private static final ThreadLocal<SharedData> SHARED_DATA = new ThreadLocal<SharedData>(){

        @Override
        protected SharedData initialValue() {
            return new SharedData();
        }
    };
    private final SharedData sharedData = SHARED_DATA.get();

    public double nCr(int n, int r) {
        if (n < 0 || r < 0 || r > n) {
            return 0.0;
        }
        if (n >= this.sharedData.pt.length) {
            int d = 2 * this.sharedData.pt.length;
            double[][] pt2 = null;
            pt2 = n > d ? new double[n + 1][] : new double[d + 1][];
            int i = 0;
            while (i < this.sharedData.pt.length) {
                pt2[i] = this.sharedData.pt[i];
                ++i;
            }
            i = this.sharedData.pt.length;
            while (i < pt2.length) {
                pt2[i] = new double[i / 2 + 1];
                pt2[i][0] = 1.0;
                int j = 1;
                while (j < pt2[i].length) {
                    double x = pt2[i - 1][j - 1];
                    x = j < pt2[i - 1].length ? (x += pt2[i - 1][j]) : (x *= 2.0);
                    pt2[i][j] = x;
                    ++j;
                }
                ++i;
            }
            this.sharedData.pt = pt2;
        }
        if (2 * r > n) {
            r = n - r;
        }
        return this.sharedData.pt[n][r];
    }

    public void reset() {
        this.sharedData.pt = new double[][]{{1.0}};
    }

    private static class SharedData {
        private double[][] pt = new double[][]{{1.0}};

        private SharedData() {
        }
    }
}

