/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.quicktime;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;
import org.monte.media.AbstractVideoCodec;
import org.monte.media.Buffer;
import org.monte.media.BufferFlag;
import org.monte.media.Format;
import org.monte.media.FormatKeys;
import org.monte.media.VideoFormatKeys;
import org.monte.media.io.SeekableByteArrayOutputStream;

public class RawCodec
extends AbstractVideoCodec {
    public RawCodec() {
        super(new Format[]{new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "Java", FormatKeys.EncodingKey, "image"})}, new Format[]{new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "video/quicktime", FormatKeys.EncodingKey, "raw ", VideoFormatKeys.DataClassKey, byte[].class, VideoFormatKeys.DepthKey, 8}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "video/quicktime", FormatKeys.EncodingKey, "raw ", VideoFormatKeys.DataClassKey, byte[].class, VideoFormatKeys.DepthKey, 16}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "video/quicktime", FormatKeys.EncodingKey, "raw ", VideoFormatKeys.DataClassKey, byte[].class, VideoFormatKeys.DepthKey, 24}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "video/quicktime", FormatKeys.EncodingKey, "raw ", VideoFormatKeys.DataClassKey, byte[].class, VideoFormatKeys.DepthKey, 32})});
    }

    public void writeKey8(OutputStream out, byte[] data, int width, int height, int offset, int scanlineStride) throws IOException {
        int xy = offset;
        int ymax = offset + height * scanlineStride;
        while (xy < ymax) {
            out.write(data, xy, width);
            xy += scanlineStride;
        }
    }

    public void writeKey16(OutputStream out, short[] data, int width, int height, int offset, int scanlineStride) throws IOException {
        byte[] bytes = new byte[width * 2];
        int xy = offset;
        int ymax = offset + height * scanlineStride;
        while (xy < ymax) {
            int x = 0;
            int i = 0;
            while (x < width) {
                short pixel = data[xy + x];
                bytes[i] = (byte)(pixel >> 8);
                bytes[i + 1] = (byte)pixel;
                ++x;
                i += 2;
            }
            out.write(bytes, 0, bytes.length);
            xy += scanlineStride;
        }
    }

    public void writeKey24(OutputStream out, int[] data, int width, int height, int offset, int scanlineStride) throws IOException {
        byte[] bytes = new byte[width * 3];
        int xy = offset;
        int ymax = offset + height * scanlineStride;
        while (xy < ymax) {
            int x = 0;
            int i = 0;
            while (x < width) {
                int pixel = data[xy + x];
                bytes[i] = (byte)(pixel >> 16);
                bytes[i + 1] = (byte)(pixel >> 8);
                bytes[i + 2] = (byte)pixel;
                ++x;
                i += 3;
            }
            out.write(bytes, 0, bytes.length);
            xy += scanlineStride;
        }
    }

    public void writeKey32(OutputStream out, int[] data, int width, int height, int offset, int scanlineStride) throws IOException {
        byte[] bytes = new byte[width * 4];
        int xy = offset;
        int ymax = offset + height * scanlineStride;
        while (xy < ymax) {
            int x = 0;
            int i = 0;
            while (x < width) {
                int pixel = data[xy + x];
                bytes[i] = (byte)(pixel >> 24);
                bytes[i + 1] = (byte)(pixel >> 16);
                bytes[i + 2] = (byte)(pixel >> 8);
                bytes[i + 3] = (byte)pixel;
                ++x;
                i += 4;
            }
            out.write(bytes, 0, bytes.length);
            xy += scanlineStride;
        }
    }

    public void writeKey24(OutputStream out, BufferedImage image) throws IOException {
        int width = image.getWidth();
        int height = image.getHeight();
        WritableRaster raster = image.getRaster();
        int[] rgb = new int[width * 3];
        byte[] bytes = new byte[width * 3];
        int y = 0;
        while (y < height) {
            rgb = raster.getPixels(0, y, width, 1, rgb);
            int k = 0;
            int n = width * 3;
            while (k < n) {
                bytes[k] = (byte)rgb[k];
                ++k;
            }
            out.write(bytes);
            ++y;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int process(Buffer in, Buffer out) {
        Rectangle r;
        int scanlineStride;
        out.setMetaTo(in);
        if (in.isFlag(BufferFlag.DISCARD)) {
            return 0;
        }
        out.format = this.outputFormat;
        SeekableByteArrayOutputStream tmp = out.data instanceof byte[] ? new SeekableByteArrayOutputStream((byte[])out.data) : new SeekableByteArrayOutputStream();
        Format vf = this.outputFormat;
        if (in.data instanceof BufferedImage) {
            BufferedImage image = (BufferedImage)in.data;
            WritableRaster raster = image.getRaster();
            scanlineStride = raster.getSampleModel().getWidth();
            r = raster.getBounds();
            r.x -= raster.getSampleModelTranslateX();
            r.y -= raster.getSampleModelTranslateY();
        } else {
            r = new Rectangle(0, 0, vf.get(VideoFormatKeys.WidthKey), vf.get(VideoFormatKeys.HeightKey));
            scanlineStride = vf.get(VideoFormatKeys.WidthKey);
        }
        try {
            switch (vf.get(VideoFormatKeys.DepthKey)) {
                case 8: {
                    this.writeKey8(tmp, this.getIndexed8(in), r.width, r.height, r.x + r.y * scanlineStride, scanlineStride);
                    break;
                }
                case 16: {
                    this.writeKey16(tmp, this.getRGB15(in), r.width, r.height, r.x + r.y * scanlineStride, scanlineStride);
                    break;
                }
                case 24: {
                    this.writeKey24(tmp, this.getRGB24(in), r.width, r.height, r.x + r.y * scanlineStride, scanlineStride);
                    break;
                }
                case 32: {
                    this.writeKey24(tmp, this.getARGB32(in), r.width, r.height, r.x + r.y * scanlineStride, scanlineStride);
                    break;
                }
                default: {
                    out.setFlag(BufferFlag.DISCARD);
                    return 1;
                }
            }
            out.format = this.outputFormat;
            out.sampleCount = 1;
            out.setFlag(BufferFlag.KEYFRAME);
            out.data = tmp.getBuffer();
            out.offset = 0;
            out.length = (int)tmp.getStreamPosition();
            return 0;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            out.setFlag(BufferFlag.DISCARD);
            return 1;
        }
    }
}

