/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.math;

import java.math.BigInteger;

public class IntMath {
    public static int gcd(int a, int b) {
        a = Math.abs(a);
        b = Math.abs(b);
        while (a > 0 && b > 0) {
            if ((a %= b) <= 0) continue;
            b %= a;
        }
        return a + b;
    }

    public static long gcd(long a, long b) {
        a = Math.abs(a);
        b = Math.abs(b);
        while (a > 0L && b > 0L) {
            if ((a %= b) <= 0L) continue;
            b %= a;
        }
        return a + b;
    }

    public static BigInteger gcd(BigInteger a, BigInteger b) {
        a = a.abs();
        b = b.abs();
        while (a.compareTo(BigInteger.ZERO) > 0 && b.compareTo(BigInteger.ZERO) > 0) {
            if ((a = a.mod(b)).compareTo(BigInteger.ZERO) <= 0) continue;
            b = b.mod(a);
        }
        return a.add(b);
    }

    public static int scm(int a, int b) {
        if (a == 0 || b == 0) {
            return 0;
        }
        a = Math.abs(a);
        b = Math.abs(b);
        int u = a;
        int v = b;
        while (a != b) {
            if (a < b) {
                b -= a;
                v += u;
                continue;
            }
            a -= b;
            u += v;
        }
        return (u + v) / 2;
    }

    public static long scm(long a, long b) {
        if (a == 0L || b == 0L) {
            return 0L;
        }
        a = Math.abs(a);
        if ((b = Math.abs(b)) == 1L) {
            return a;
        }
        if (a == 1L) {
            return b;
        }
        long u = a;
        long v = b;
        while (a != b) {
            if (a < b) {
                b -= a;
                v += u;
                continue;
            }
            a -= b;
            u += v;
        }
        return (u + v) / 2L;
    }

    public static BigInteger scm(BigInteger a, BigInteger b) {
        if (a.compareTo(BigInteger.ZERO) == 0 || b.compareTo(BigInteger.ZERO) == 0) {
            return BigInteger.ZERO;
        }
        a = a.abs();
        if ((b = b.abs()).compareTo(BigInteger.ONE) == 0) {
            return a;
        }
        if (a.compareTo(BigInteger.ONE) == 0) {
            return b;
        }
        BigInteger u = a;
        BigInteger v = b;
        while (a.compareTo(b) != 0) {
            if (a.compareTo(b) < 0) {
                b = b.subtract(a);
                v = v.add(u);
                continue;
            }
            a = a.subtract(b);
            u = u.add(v);
        }
        return u.add(v).divide(BigInteger.valueOf(2L));
    }

    public static int reverseBits(int a) {
        return IntMath.reverseBits(a, 32);
    }

    public static int reverseBits(int a, int numBits) {
        int b = 0;
        int i = 0;
        while (i < numBits) {
            b <<= 1;
            b |= a & 1;
            a >>>= 1;
            ++i;
        }
        return b;
    }

    public static void main(String[] args) {
        int i = 0;
        while (i < 8) {
            int a = 1 << i;
            int b = IntMath.reverseBits(a, 3);
            System.out.println(String.valueOf(a) + " - " + b);
            ++i;
        }
    }
}

