/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.jpeg;

import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import org.monte.media.AbstractVideoCodec;
import org.monte.media.Buffer;
import org.monte.media.BufferFlag;
import org.monte.media.Format;
import org.monte.media.FormatKeys;
import org.monte.media.VideoFormatKeys;
import org.monte.media.io.ByteArrayImageInputStream;
import org.monte.media.io.ByteArrayImageOutputStream;
import org.monte.media.jpeg.MJPGImageReader;
import org.monte.media.jpeg.MJPGImageReaderSpi;

public class JPEGCodec
extends AbstractVideoCodec {
    public JPEGCodec() {
        super(new Format[]{new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "Java", FormatKeys.EncodingKey, "image"}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "video/quicktime", FormatKeys.EncodingKey, "jpeg", VideoFormatKeys.CompressorNameKey, "Photo - JPEG", VideoFormatKeys.DataClassKey, byte[].class, VideoFormatKeys.DepthKey, 24}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "video/avi", FormatKeys.EncodingKey, "MJPG", VideoFormatKeys.DataClassKey, byte[].class, VideoFormatKeys.DepthKey, 24})}, new Format[]{new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "Java", FormatKeys.EncodingKey, "image"}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "video/quicktime", FormatKeys.EncodingKey, "jpeg", VideoFormatKeys.CompressorNameKey, "Photo - JPEG", VideoFormatKeys.DataClassKey, byte[].class, VideoFormatKeys.DepthKey, 24}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "video/avi", FormatKeys.EncodingKey, "MJPG", VideoFormatKeys.DataClassKey, byte[].class, VideoFormatKeys.DepthKey, 24})});
        this.name = "JPEG Codec";
    }

    @Override
    public int process(Buffer in, Buffer out) {
        if (this.outputFormat.get(FormatKeys.EncodingKey).equals("image")) {
            return this.decode(in, out);
        }
        return this.encode(in, out);
    }

    public int encode(Buffer in, Buffer out) {
        out.setMetaTo(in);
        out.format = this.outputFormat;
        if (in.isFlag(BufferFlag.DISCARD)) {
            return 0;
        }
        BufferedImage image = this.getBufferedImage(in);
        if (image == null) {
            out.setFlag(BufferFlag.DISCARD);
            return 1;
        }
        ByteArrayImageOutputStream tmp = out.data instanceof byte[] ? new ByteArrayImageOutputStream((byte[])out.data) : new ByteArrayImageOutputStream();
        try {
            ImageWriter iw = ImageIO.getImageWritersByMIMEType("image/jpeg").next();
            ImageWriteParam iwParam = iw.getDefaultWriteParam();
            iwParam.setCompressionMode(2);
            float quality = this.outputFormat.get(VideoFormatKeys.QualityKey, Float.valueOf(1.0f)).floatValue();
            iwParam.setCompressionQuality(quality);
            iw.setOutput(tmp);
            IIOImage img = new IIOImage(image, null, null);
            iw.write(null, img, iwParam);
            iw.dispose();
            out.sampleCount = 1;
            out.setFlag(BufferFlag.KEYFRAME);
            out.data = tmp.getBuffer();
            out.offset = 0;
            out.length = (int)tmp.getStreamPosition();
            return 0;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            out.setFlag(BufferFlag.DISCARD);
            return 1;
        }
    }

    public int decode(Buffer in, Buffer out) {
        out.setMetaTo(in);
        out.format = this.outputFormat;
        if (in.isFlag(BufferFlag.DISCARD)) {
            return 0;
        }
        byte[] data = (byte[])in.data;
        if (data == null) {
            out.setFlag(BufferFlag.DISCARD);
            return 1;
        }
        ByteArrayImageInputStream tmp = new ByteArrayImageInputStream(data);
        try {
            MJPGImageReader ir = new MJPGImageReader(new MJPGImageReaderSpi());
            ir.setInput(tmp);
            out.data = ir.read(0);
            ir.dispose();
            out.sampleCount = 1;
            out.offset = 0;
            out.length = (int)tmp.getStreamPosition();
            return 0;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            out.setFlag(BufferFlag.DISCARD);
            return 1;
        }
    }
}

