/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.ilbm;

import java.util.Arrays;
import org.monte.media.ilbm.ColorCycle;

public class DRNGColorCycle
extends ColorCycle {
    private int min;
    private int max;
    private boolean isEHB;
    private Cell[] ic;
    private Cell[] cells;
    private boolean isReverse;

    public DRNGColorCycle(int rate, int timeScale, int min, int max, boolean isActive, boolean isEHB, Cell[] cells) {
        super(rate, timeScale, isActive);
        this.min = min;
        this.max = max;
        this.isEHB = isEHB;
        this.cells = cells;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    private void interpolateCells(int[] rgbs) {
        this.ic = new Cell[this.max - this.min + 1];
        Arrays.sort(this.cells);
        int i = 0;
        while (i < this.cells.length) {
            this.ic[this.cells[i].cell - this.min] = this.cells[i];
            this.cells[i].readValue(rgbs, false);
            ++i;
        }
        int left = this.cells.length - 1;
        int right = 0;
        int i2 = 0;
        while (i2 < this.ic.length) {
            if (this.cells[right].cell == i2) {
                left = right;
                right = right == this.cells.length - 1 ? 0 : right + 1;
            } else {
                int levels = this.cells[left].cell < this.cells[right].cell ? this.cells[right].cell - this.cells[left].cell : this.max - this.cells[left].cell + this.cells[right].cell + 1;
                int blend = this.cells[right].cell > i2 + this.min ? this.cells[right].cell - (i2 + this.min) : this.max - (i2 + this.min) + this.cells[right].cell + 1;
                int lrgb = this.cells[left].value;
                int rrgb = this.cells[right].value;
                this.ic[i2] = new DColorCell(i2, ((lrgb & 0xFF0000) * blend + (rrgb & 0xFF0000) * (levels - blend)) / levels & 0xFF0000 | ((lrgb & 0xFF00) * blend + (rrgb & 0xFF00) * (levels - blend)) / levels & 0xFF00 | ((lrgb & 0xFF) * blend + (rrgb & 0xFF) * (levels - blend)) / levels);
            }
            ++i2;
        }
    }

    @Override
    public void doCycle(int[] rgbs, long time) {
        block18: {
            int i;
            int tmp;
            int shift;
            block19: {
                int i2;
                int tmp2;
                if (!this.isActive) break block18;
                if (this.ic == null) {
                    this.interpolateCells(rgbs);
                }
                shift = (int)(time * (long)this.rate / (long)this.timeScale / 1000L % (long)this.ic.length);
                if (!this.isReverse) break block19;
                int i3 = 0;
                while (i3 < this.ic.length) {
                    this.ic[i3].readValue(rgbs, false);
                    ++i3;
                }
                int j = 0;
                while (j < shift) {
                    tmp2 = this.ic[0].value;
                    i2 = 1;
                    while (i2 < this.ic.length) {
                        this.ic[i2 - 1].value = this.ic[i2].value;
                        ++i2;
                    }
                    this.ic[this.ic.length - 1].value = tmp2;
                    ++j;
                }
                i3 = 0;
                while (i3 < this.ic.length) {
                    this.ic[i3].writeValue(rgbs, false);
                    ++i3;
                }
                if (!this.isEHB) break block18;
                i3 = 0;
                while (i3 < this.ic.length) {
                    this.ic[i3].readValue(rgbs, true);
                    ++i3;
                }
                j = 0;
                while (j < shift) {
                    tmp2 = this.ic[0].value;
                    i2 = 1;
                    while (i2 < this.ic.length) {
                        this.ic[i2 - 1].value = this.ic[i2].value;
                        ++i2;
                    }
                    this.ic[this.ic.length - 1].value = tmp2;
                    ++j;
                }
                i3 = 0;
                while (i3 < this.ic.length) {
                    this.ic[i3].writeValue(rgbs, true);
                    ++i3;
                }
                break block18;
            }
            int i4 = 0;
            while (i4 < this.ic.length) {
                this.ic[i4].readValue(rgbs, false);
                ++i4;
            }
            int j = 0;
            while (j < shift) {
                tmp = this.ic[this.ic.length - 1].value;
                i = this.ic.length - 1;
                while (i > 0) {
                    this.ic[i].value = this.ic[i - 1].value;
                    --i;
                }
                this.ic[0].value = tmp;
                ++j;
            }
            i4 = 0;
            while (i4 < this.ic.length) {
                this.ic[i4].writeValue(rgbs, false);
                ++i4;
            }
            if (this.isEHB) {
                i4 = 0;
                while (i4 < this.ic.length) {
                    this.ic[i4].readValue(rgbs, true);
                    ++i4;
                }
                j = 0;
                while (j < shift) {
                    tmp = this.ic[this.ic.length - 1].value;
                    i = this.ic.length - 1;
                    while (i > 0) {
                        this.ic[i].value = this.ic[i - 1].value;
                        --i;
                    }
                    this.ic[0].value = tmp;
                    ++j;
                }
                i4 = 0;
                while (i4 < this.ic.length) {
                    this.ic[i4].writeValue(rgbs, true);
                    ++i4;
                }
            }
        }
    }

    public static abstract class Cell
    implements Comparable<Cell> {
        protected int cell;
        protected int value;

        public Cell(int cell) {
            this.cell = cell;
        }

        public abstract void readValue(int[] var1, boolean var2);

        public abstract void writeValue(int[] var1, boolean var2);

        @Override
        public int compareTo(Cell that) {
            return this.cell - that.cell;
        }

        public boolean equals(Object o) {
            if (o instanceof Cell) {
                Cell that = (Cell)o;
                return that.cell == this.cell;
            }
            return false;
        }

        public int hashCode() {
            return this.cell;
        }
    }

    public static class DColorCell
    extends Cell {
        private int rgb;

        public DColorCell(int cell, int rgb) {
            super(cell);
            this.rgb = rgb;
        }

        @Override
        public void readValue(int[] rgbs, boolean isHalfbright) {
            this.value = isHalfbright ? this.rgb & 0xF0F0F : this.rgb;
        }

        @Override
        public void writeValue(int[] rgbs, boolean isHalfbright) {
        }
    }

    public static class DIndexCell
    extends Cell {
        private int index;

        public DIndexCell(int cell, int index) {
            super(cell);
            this.index = index;
        }

        @Override
        public void readValue(int[] rgbs, boolean isHalfbright) {
            this.value = isHalfbright ? rgbs[this.index + 32] : rgbs[this.index];
        }

        @Override
        public void writeValue(int[] rgbs, boolean isHalfbright) {
            rgbs[isHalfbright ? this.index + 32 : this.index] = this.value;
        }
    }
}

