/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.anim;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.monte.media.Format;
import org.monte.media.FormatKeys;
import org.monte.media.MovieWriter;
import org.monte.media.VideoFormatKeys;
import org.monte.media.anim.ANIMMultiplexer;
import org.monte.media.anim.AmigaVideoFormatKeys;
import org.monte.media.math.Rational;

public class ANIMWriter
extends ANIMMultiplexer
implements MovieWriter {
    public static final Format ANIM = new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.FILE, FormatKeys.MimeTypeKey, "x-iff/anim"});
    private ArrayList<Track> tracks = new ArrayList();

    @Override
    public Format getFileFormat() throws IOException {
        return ANIM;
    }

    @Override
    public Rational getDuration(int track) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ANIMWriter(File file) throws IOException {
        super(file);
    }

    @Override
    public int addTrack(Format format) throws IOException {
        if (this.tracks.size() > 0) {
            throw new UnsupportedOperationException("only 1 track supported");
        }
        Format derivedFormat = format.prepend(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "x-iff/anim", FormatKeys.EncodingKey, "op5", VideoFormatKeys.DataClassKey, byte[].class, VideoFormatKeys.FixedFrameRateKey, false});
        this.setCAMG(AmigaVideoFormatKeys.toCAMG(derivedFormat));
        Track tr = new Track();
        tr.format = derivedFormat;
        this.tracks.add(tr);
        return this.tracks.size() - 1;
    }

    @Override
    public Format getFormat(int track) {
        return this.tracks.get((int)track).format;
    }

    @Override
    public int getTrackCount() {
        return this.tracks.size();
    }

    public boolean isVFRSupported() {
        return true;
    }

    @Override
    public boolean isDataLimitReached() {
        return false;
    }

    @Override
    public boolean isEmpty(int track) {
        return this.inputTime.isZero();
    }

    private static class Track {
        Format format;

        private Track() {
        }
    }
}

