/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.anim;

import java.awt.image.IndexColorModel;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.imageio.stream.FileImageOutputStream;
import org.monte.media.anim.AmigaDisplayInfo;
import org.monte.media.iff.IFFOutputStream;
import org.monte.media.image.BitmapImage;
import org.monte.media.io.SeekableByteArrayOutputStream;

public class ANIMOutputStream {
    public static final int MONITOR_ID_MASK = -61440;
    public static final int DEFAULT_MONITOR_ID = 0;
    public static final int NTSC_MONITOR_ID = 69632;
    public static final int PAL_MONITOR_ID = 135168;
    public static final int MULTISCAN_MONITOR_ID = 200704;
    public static final int A2024_MONITOR_ID = 266240;
    public static final int PROTO_MONITOR_ID = 331776;
    public static final int EURO72_MONITOR_ID = 397312;
    public static final int EURO36_MONITOR_ID = 462848;
    public static final int SUPER72_MONITOR_ID = 528384;
    public static final int DBLNTSC_MONITOR_ID = 593920;
    public static final int DBLPAL_MONITOR_ID = 4096;
    public static final int MODE_MASK = 2176;
    public static final int HAM_MODE = 2048;
    public static final int EHB_MODE = 128;
    private int jiffies = 60;
    private int camg;
    private boolean debug = false;
    private IFFOutputStream out = null;
    protected int frameCount = 0;
    protected int absTime = 0;
    private BitmapImage oddPrev;
    private BitmapImage evenPrev;
    private BitmapImage firstFrame;
    private int firstWrapupDuration = 1;
    private int secondWrapupDuration = 1;
    private long numberOfFramesOffset = -1L;
    private States state = States.REALIZED;

    public ANIMOutputStream(File file) throws IOException {
        this.out = new IFFOutputStream(new FileImageOutputStream(file));
    }

    public void setJiffies(int newValue) {
        this.jiffies = newValue;
    }

    public int getJiffies() {
        return this.jiffies;
    }

    public void setCAMG(int newValue) {
        this.camg = newValue;
        AmigaDisplayInfo info = AmigaDisplayInfo.getInfo(newValue);
        if (info != null) {
            this.jiffies = info.fps;
        }
    }

    public int getCAMG() {
        return this.camg;
    }

    private void ensureOpen() throws IOException {
        if (this.state == States.CLOSED) {
            throw new IOException("Stream closed");
        }
    }

    private void ensureStarted() throws IOException {
        this.ensureOpen();
        if (this.state == States.FINISHED) {
            throw new IOException("Can not write into finished movie.");
        }
        if (this.state != States.STARTED) {
            this.writeProlog();
            this.state = States.STARTED;
        }
    }

    public void finish() throws IOException {
        this.ensureOpen();
        if (this.state != States.FINISHED) {
            this.writeEpilog();
            this.out.finish();
            this.state = States.FINISHED;
        }
    }

    public void close() throws IOException {
        try {
            if (this.state == States.STARTED) {
                this.finish();
            }
        }
        finally {
            if (this.state != States.CLOSED) {
                this.out.close();
                this.state = States.CLOSED;
            }
        }
    }

    private void writeProlog() throws IOException {
        this.out.pushCompositeChunk("FORM", "ANIM");
    }

    private void writeEpilog() throws IOException {
        if (this.frameCount > 0) {
            this.writeDeltaFrame(this.firstFrame, this.firstWrapupDuration);
            this.writeDeltaFrame(this.firstFrame, this.secondWrapupDuration);
        }
        this.out.popChunk();
        if (this.numberOfFramesOffset != -1L) {
            long pos = this.out.getStreamPosition();
            this.out.seek(this.numberOfFramesOffset);
            this.out.writeUWORD(Math.max(0, this.frameCount - 2));
            this.out.seek(pos);
        }
    }

    public void writeFrame(BitmapImage image, int duration) throws IOException {
        this.ensureStarted();
        if (this.frameCount == 0) {
            this.writeFirstFrame(image, duration);
        } else {
            this.writeDeltaFrame(image, duration);
        }
    }

    private void writeFirstFrame(BitmapImage img, int duration) throws IOException {
        this.out.pushCompositeChunk("FORM", "ILBM");
        this.writeBMHD(this.out, img);
        this.writeCMAP(this.out, img);
        this.writeANHD(this.out, img.getWidth(), img.getHeight(), 0, this.absTime, duration);
        this.writeCAMG(this.out, this.camg);
        this.writeBODY(this.out, img);
        this.out.popChunk();
        this.firstFrame = new BitmapImage(img.getWidth(), img.getHeight(), img.getDepth(), img.getPlanarColorModel());
        this.oddPrev = new BitmapImage(img.getWidth(), img.getHeight(), img.getDepth(), img.getPlanarColorModel());
        this.evenPrev = new BitmapImage(img.getWidth(), img.getHeight(), img.getDepth(), img.getPlanarColorModel());
        System.arraycopy(img.getBitmap(), 0, this.firstFrame.getBitmap(), 0, img.getBitmap().length);
        System.arraycopy(img.getBitmap(), 0, this.oddPrev.getBitmap(), 0, img.getBitmap().length);
        System.arraycopy(img.getBitmap(), 0, this.evenPrev.getBitmap(), 0, img.getBitmap().length);
        this.absTime += duration;
        this.firstWrapupDuration = this.secondWrapupDuration = duration;
        ++this.frameCount;
    }

    private void writeDeltaFrame(BitmapImage img, int duration) throws IOException {
        BitmapImage prev = (this.frameCount & 1) == 0 ? this.evenPrev : this.oddPrev;
        BitmapImage immPrev = (this.frameCount & 1) == 0 ? this.oddPrev : this.evenPrev;
        this.out.pushCompositeChunk("FORM", "ILBM");
        this.writeANHD(this.out, img.getWidth(), img.getHeight(), 5, this.absTime, duration);
        this.writeCMAP(this.out, img, immPrev);
        this.writeDLTA(this.out, img, prev);
        this.out.popChunk();
        System.arraycopy(img.getBitmap(), 0, prev.getBitmap(), 0, prev.getBitmap().length);
        prev.setPlanarColorModel(img.getPlanarColorModel());
        this.absTime += duration;
        this.firstWrapupDuration = this.secondWrapupDuration = duration;
        ++this.frameCount;
    }

    public long getMovieTime() {
        return this.absTime;
    }

    private void writeBMHD(IFFOutputStream out, BitmapImage img) throws IOException {
        AmigaDisplayInfo info = AmigaDisplayInfo.getInfo(this.camg);
        if (info == null) {
            info = AmigaDisplayInfo.getInfo(0);
        }
        out.pushDataChunk("BMHD");
        out.writeUWORD(img.getWidth());
        out.writeUWORD(img.getHeight());
        out.writeWORD(0);
        out.writeWORD(0);
        out.writeUBYTE(img.getDepth());
        out.writeUBYTE(0);
        out.writeUBYTE(1);
        out.writeUBYTE(0);
        out.writeUWORD(0);
        out.writeUBYTE(info.resolutionX);
        out.writeUBYTE(info.resolutionY);
        out.writeUWORD(img.getWidth());
        out.writeUWORD(img.getHeight());
        out.popChunk();
    }

    private void writeCMAP(IFFOutputStream out, BitmapImage img) throws IOException {
        out.pushDataChunk("CMAP");
        IndexColorModel cm = (IndexColorModel)img.getPlanarColorModel();
        int i = 0;
        int n = cm.getMapSize();
        while (i < n) {
            out.writeUBYTE(cm.getRed(i));
            out.writeUBYTE(cm.getGreen(i));
            out.writeUBYTE(cm.getBlue(i));
            ++i;
        }
        out.popChunk();
    }

    private void writeCMAP(IFFOutputStream out, BitmapImage img, BitmapImage prev) throws IOException {
        IndexColorModel cm = (IndexColorModel)img.getPlanarColorModel();
        IndexColorModel prevCm = (IndexColorModel)prev.getPlanarColorModel();
        boolean equals = true;
        int i = 0;
        int n = cm.getMapSize();
        while (i < n) {
            if (cm.getRGB(i) != prevCm.getRGB(i)) {
                equals = false;
                break;
            }
            ++i;
        }
        if (!equals) {
            this.writeCMAP(out, img);
        }
    }

    private void writeCAMG(IFFOutputStream out, int camg) throws IOException {
        out.pushDataChunk("CAMG");
        out.writeLONG(camg);
        out.popChunk();
    }

    private void writeDPAN(IFFOutputStream out) throws IOException {
        out.pushDataChunk("DPAN");
        out.writeUWORD(4);
        this.numberOfFramesOffset = out.getStreamPosition();
        out.writeUWORD(-1);
        out.writeULONG(0L);
        out.popChunk();
    }

    private void writeBODY(IFFOutputStream out, BitmapImage img) throws IOException {
        out.pushDataChunk("BODY");
        int widthInBytes = (img.getWidth() + 7) / 8;
        int ss = img.getScanlineStride();
        int bs = img.getBitplaneStride();
        int offset = 0;
        byte[] data = img.getBitmap();
        int y = 0;
        int h = img.getHeight();
        while (y < h) {
            int p = 0;
            int d = img.getDepth();
            while (p < d) {
                out.writeByteRun1(data, offset + bs * p, widthInBytes);
                ++p;
            }
            offset += ss;
            ++y;
        }
        out.popChunk();
    }

    private void writeDLTA(IFFOutputStream out, BitmapImage img, BitmapImage prev) throws IOException {
        out.pushDataChunk("DLTA");
        int height = img.getHeight();
        int widthInBytes = (img.getWidth() + 7) / 8;
        int ss = img.getScanlineStride();
        int bs = img.getBitplaneStride();
        boolean offset = false;
        byte[] data = img.getBitmap();
        byte[] prevData = prev.getBitmap();
        SeekableByteArrayOutputStream buf = new SeekableByteArrayOutputStream();
        byte[][] planes = new byte[16][0];
        int depth = img.getDepth();
        int p = 0;
        while (p < depth) {
            buf.reset();
            int column = 0;
            while (column < widthInBytes) {
                this.writeByteVertical(buf, data, prevData, bs * p + column, height, ss);
                ++column;
            }
            planes[p] = buf.toByteArray();
            if (planes[p].length == widthInBytes) {
                planes[p] = new byte[0];
            }
            ++p;
        }
        int[] pPointers = new int[16];
        int p2 = 0;
        while (p2 < depth) {
            if (planes[p2].length == 0) {
                pPointers[p2] = 0;
            } else {
                pPointers[p2] = 64;
                int q = 0;
                while (q < p2) {
                    if (Arrays.equals(planes[q], planes[p2])) {
                        pPointers[p2] = pPointers[q];
                        planes[p2] = new byte[0];
                        break;
                    }
                    int n = p2;
                    pPointers[n] = pPointers[n] + planes[q].length;
                    ++q;
                }
            }
            ++p2;
        }
        p2 = 0;
        while (p2 < pPointers.length) {
            out.writeULONG(pPointers[p2]);
            ++p2;
        }
        p2 = 0;
        while (p2 < planes.length) {
            out.write(planes[p2]);
            ++p2;
        }
        out.popChunk();
    }

    private void writeByteVertical(SeekableByteArrayOutputStream out, byte[] data, byte[] prev, int offset, int length, int step) throws IOException {
        int opCount = 0;
        long opCountPos = out.getStreamPosition();
        out.write(0);
        int literalOffset = 0;
        int i = 0;
        while (i < length) {
            int skipCount = i;
            while (skipCount < length) {
                if (data[offset + skipCount * step] != prev[offset + skipCount * step]) break;
                ++skipCount;
            }
            if ((skipCount -= i) + i == length) break;
            if (skipCount > 0 && literalOffset == i || skipCount > 1) {
                if (literalOffset < i) {
                    ++opCount;
                    out.write(0x80 | i - literalOffset);
                    int j = literalOffset;
                    while (j < i) {
                        out.write(data[offset + j * step]);
                        ++j;
                    }
                }
                literalOffset = (i += skipCount - 1) + 1;
                while (skipCount > 127) {
                    ++opCount;
                    out.write(127);
                    skipCount -= 127;
                }
                ++opCount;
                out.write(skipCount);
            } else {
                int j;
                byte b = data[offset + i * step];
                int repeatCount = i + 1;
                while (repeatCount < length) {
                    if (data[offset + repeatCount * step] != b) break;
                    ++repeatCount;
                }
                if ((repeatCount -= i) == 1) {
                    if (i - literalOffset > 126) {
                        ++opCount;
                        out.write(0x80 | i - literalOffset);
                        j = literalOffset;
                        while (j < i) {
                            out.write(data[offset + j * step]);
                            ++j;
                        }
                        literalOffset = i;
                    }
                } else if (repeatCount < 4 && literalOffset < i && i - literalOffset < 126) {
                    ++i;
                } else {
                    if (literalOffset < i) {
                        ++opCount;
                        out.write(0x80 | i - literalOffset);
                        j = literalOffset;
                        while (j < i) {
                            out.write(data[offset + j * step]);
                            ++j;
                        }
                    }
                    literalOffset = (i += repeatCount - 1) + 1;
                    while (repeatCount > 255) {
                        ++opCount;
                        out.write(0);
                        out.write(255);
                        out.write(b);
                        repeatCount -= 255;
                    }
                    ++opCount;
                    out.write(0);
                    out.write(repeatCount);
                    out.write(b);
                }
            }
            ++i;
        }
        if (literalOffset < i) {
            ++opCount;
            out.write(0x80 | i - literalOffset);
            int j = literalOffset;
            while (j < i) {
                out.write(data[offset + j * step]);
                ++j;
            }
        }
        long pos = out.getStreamPosition();
        out.seek(opCountPos);
        out.write(opCount);
        out.seek(pos);
    }

    private void writeANHD(IFFOutputStream out, int width, int height, int compressionMode, int absTime, int relTime) throws IOException {
        out.pushDataChunk("ANHD");
        out.writeUBYTE(compressionMode);
        out.writeUBYTE(0);
        out.writeUWORD(width);
        out.writeUWORD(height);
        out.writeUWORD(0);
        out.writeUWORD(0);
        out.writeULONG(absTime);
        out.writeULONG(relTime);
        out.writeUBYTE(0);
        out.writeUBYTE(0);
        out.writeULONG(0L);
        out.writeULONG(0L);
        out.writeULONG(0L);
        out.writeULONG(0L);
        out.writeULONG(0L);
        out.popChunk();
    }

    private static enum States {
        REALIZED,
        STARTED,
        FINISHED,
        CLOSED;

    }
}

