/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.anim;

import java.awt.image.ColorModel;
import java.util.Vector;
import org.monte.media.anim.ANIMAudioCommand;
import org.monte.media.anim.ANIMMovieTrack;
import org.monte.media.image.BitmapImage;

public abstract class ANIMFrame {
    protected ColorModel colorModel;
    protected byte[] data;
    private int operation;
    private int mask;
    private long reltime;
    private int interleave;
    private int bits;
    protected static final int BadBitsOP_GeneralDelta = 65472;
    protected static final int BIT_LongData = 1;
    protected static final int BIT_XOR = 2;
    protected static final int BIT_OneInfoListForAllPlanes = 4;
    protected static final int BIT_RLC = 8;
    protected static final int BIT_Vertical = 16;
    protected static final int BIT_LongInfoOffsets = 32;
    protected static final int BadBitsOP_ByteVertical = 65527;
    private ANIMAudioCommand[] audioCommands;

    public void addAudioCommand(ANIMAudioCommand command) {
        if (this.audioCommands == null) {
            this.audioCommands = new ANIMAudioCommand[1];
        } else {
            ANIMAudioCommand[] old = this.audioCommands;
            this.audioCommands = new ANIMAudioCommand[old.length + 1];
            System.arraycopy(old, 0, this.audioCommands, 0, old.length);
        }
        this.audioCommands[this.audioCommands.length - 1] = command;
    }

    public ANIMAudioCommand[] getAudioCommands() {
        return this.audioCommands;
    }

    public void cleanUpAudioCommands() {
        if (this.audioCommands != null && this.audioCommands.length > 1) {
            Vector<ANIMAudioCommand> v = new Vector<ANIMAudioCommand>();
            v.addElement(this.audioCommands[0]);
            int i = 1;
            while (i < this.audioCommands.length) {
                int j = 0;
                while (j < i) {
                    if ((this.audioCommands[j].getChannelMask() & this.audioCommands[i].getChannelMask()) != 0) break;
                    ++j;
                }
                if (j == i) {
                    v.addElement(this.audioCommands[i]);
                }
                ++i;
            }
            this.audioCommands = new ANIMAudioCommand[v.size()];
            v.copyInto(this.audioCommands);
        }
    }

    public void setColorModel(ColorModel cm) {
        this.colorModel = cm;
    }

    public ColorModel getColorModel() {
        return this.colorModel;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public void setOperation(int operation) {
        this.operation = operation;
    }

    public void setMask(int mask) {
        this.mask = mask;
    }

    public void setWidth(int w) {
    }

    public void setHeight(int h) {
    }

    public void setX(int x) {
    }

    public void setY(int y) {
    }

    public void setAbsTime(long abstime) {
    }

    public void setRelTime(long reltime) {
        this.reltime = reltime;
    }

    public void setInterleave(int interleave) {
        this.interleave = interleave;
    }

    public void setBits(int bits) {
        this.bits = bits;
    }

    public int getOperation() {
        return this.operation;
    }

    public int getBits() {
        return this.bits;
    }

    public long getRelTime() {
        return this.reltime;
    }

    public int getInterleave() {
        return this.interleave;
    }

    public abstract void decode(BitmapImage var1, ANIMMovieTrack var2);

    public int getTopBound(ANIMMovieTrack track) {
        return 0;
    }

    public int getBottomBound(ANIMMovieTrack track) {
        return track.getHeight() - 1;
    }

    public int getLeftBound(ANIMMovieTrack track) {
        return 0;
    }

    public int getRightBound(ANIMMovieTrack track) {
        return track.getWidth() - 1;
    }

    public boolean isBidirectional() {
        return true;
    }
}

