/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media;

import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.monte.media.Animator;
import org.monte.media.Interpolator;

public class SynchronousAnimator
implements Animator {
    protected EventListenerList listenerList = new EventListenerList();
    protected ChangeEvent changeEvent;
    private Object lock;
    private long currentTimeMillis;
    private ArrayList<Interpolator> activeInterpolators = new ArrayList();
    private ArrayList<Interpolator> newInterpolators = new ArrayList();

    @Override
    public void setLock(Object lock) {
        this.lock = lock;
    }

    @Override
    public boolean isActive() {
        return !this.newInterpolators.isEmpty() || !this.activeInterpolators.isEmpty();
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        this.newInterpolators.clear();
        this.activeInterpolators.clear();
    }

    public void setTime(long currentTimeMillis) {
        this.currentTimeMillis = currentTimeMillis;
    }

    @Override
    public void dispatch(Interpolator interpolator) {
        this.newInterpolators.add(interpolator);
    }

    @Override
    public void animateStep() {
        long now = this.currentTimeMillis;
        int i = 0;
        while (i < this.newInterpolators.size()) {
            Interpolator before;
            Interpolator candidate = this.newInterpolators.get(i);
            boolean isEnqueueable = true;
            int j = 0;
            while (j < i) {
                before = this.newInterpolators.get(j);
                if (candidate.isSequential(before)) {
                    isEnqueueable = false;
                    break;
                }
                ++j;
            }
            if (isEnqueueable) {
                j = 0;
                while (j < this.activeInterpolators.size()) {
                    before = this.activeInterpolators.get(j);
                    if (candidate.replaces(before)) {
                        before.finish(now);
                    }
                    if (candidate.isSequential(before)) {
                        isEnqueueable = false;
                        break;
                    }
                    ++j;
                }
            }
            if (isEnqueueable) {
                candidate.initialize(now);
                this.activeInterpolators.add(candidate);
                if (this.newInterpolators.size() > 0) {
                    this.newInterpolators.remove(i--);
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.activeInterpolators.size()) {
            Interpolator active = this.activeInterpolators.get(i);
            if (active.isFinished()) {
                this.activeInterpolators.remove(i--);
            } else if (active.isElapsed(now)) {
                active.finish(now);
                this.activeInterpolators.remove(i--);
            } else {
                active.interpolate(now);
            }
            ++i;
        }
    }

    @Override
    public void run() {
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(ChangeListener.class, listener);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ChangeListener.class) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
            }
            i -= 2;
        }
    }

    @Override
    public boolean isSynchronous() {
        return true;
    }
}

