/*
 * Decompiled with CFR 0.152.
 */
package org.monte.iodemo;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.monte.media.Buffer;
import org.monte.media.MovieReader;
import org.monte.media.MovieWriter;
import org.monte.media.Registry;

public class ConcatDemoMain {
    public static void main(String[] args) {
        File outfile = null;
        ArrayList<File> infiles = new ArrayList<File>();
        try {
            int arg = 32;
            int i = 0;
            while (i < args.length) {
                if (args[i].length() > 1 && args[i].charAt(0) == '-') {
                    arg = args[i].charAt(1);
                } else {
                    switch (arg) {
                        case 111: {
                            if (outfile != null) {
                                throw new IllegalArgumentException("error: only one outputfile allowed");
                            }
                            outfile = new File(args[i]);
                            break;
                        }
                        case 105: {
                            infiles.add(new File(args[i]));
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("error: illegal option: " + args[i]);
                        }
                    }
                }
                ++i;
            }
            if (outfile == null) {
                throw new IllegalArgumentException("error: no outputfile specified");
            }
            if (infiles.size() == 0) {
                throw new IllegalArgumentException("error: no inputfiles specified");
            }
            for (File f : infiles) {
                if (f.exists()) continue;
                throw new IllegalArgumentException("error: inputfile does not exist: " + f);
            }
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
            System.err.println("usage: java -jar ConcatDemo.jar [-o outputfile] [-i inputfile ...]");
            String version = ConcatDemoMain.class.getPackage().getImplementationVersion();
            System.err.println("ConcatDemo " + (version == null ? "" : String.valueOf(version) + " ") + "(c) Werner Randelshofer");
            System.exit(10);
        }
        try {
            ConcatDemoMain.concat(outfile, infiles);
        }
        catch (IOException e) {
            System.err.println("error: " + e.getMessage());
        }
    }

    private static void concat(File outfile, ArrayList<File> infiles) throws IOException {
        MovieWriter out = Registry.getInstance().getWriter(outfile);
        if (out == null) {
            throw new IOException("output file format not supported for: " + outfile);
        }
        try {
            int[][] matchingT = new int[infiles.size()][0];
            int i = 0;
            int imax = infiles.size();
            while (i < imax) {
                File infile = infiles.get(i);
                MovieReader in = Registry.getInstance().getReader(infile);
                if (in == null) {
                    throw new IOException("input file format not supported for: " + infile);
                }
                try {
                    matchingT[i] = new int[in.getTrackCount()];
                    int t = 0;
                    int jmax = in.getTrackCount();
                    while (t < jmax) {
                        matchingT[i][t] = -1;
                        int outputTrack = 0;
                        int nOutputTracks = out.getTrackCount();
                        while (outputTrack < nOutputTracks) {
                            if (in.getFormat(t).matches(out.getFormat(outputTrack))) {
                                int tt = 0;
                                while (tt < t) {
                                    if (matchingT[i][tt] == outputTrack) {
                                        // empty if block
                                    }
                                    ++tt;
                                }
                                matchingT[i][t] = outputTrack;
                                break;
                            }
                            ++outputTrack;
                        }
                        if (matchingT[i][t] == -1) {
                            matchingT[i][t] = out.getTrackCount();
                            out.addTrack(in.getFormat(t));
                        }
                        ++t;
                    }
                }
                finally {
                    in.close();
                }
                ++i;
            }
            Buffer buf = new Buffer();
            int i2 = 0;
            int imax2 = infiles.size();
            while (i2 < imax2) {
                File infile = infiles.get(i2);
                MovieReader in = Registry.getInstance().getReader(infile);
                if (in == null) {
                    throw new IOException("input file format not supported for: " + infile);
                }
                try {
                    int t = in.nextTrack();
                    while (t != -1) {
                        in.read(t, buf);
                        out.write(matchingT[i2][t], buf);
                        t = in.nextTrack();
                    }
                }
                finally {
                    in.close();
                }
                ++i2;
            }
        }
        finally {
            out.close();
        }
    }
}

