/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.iconloader.util;

import com.bulenkov.iconloader.util.ArrayUtilRt;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ReflectionUtil {
    private ReflectionUtil() {
    }

    public static Type resolveVariable(TypeVariable variable, Class classType) {
        return ReflectionUtil.resolveVariable(variable, classType, true);
    }

    public static Type resolveVariable(TypeVariable variable, Class classType, boolean resolveInInterfacesOnly) {
        Class<?> aClass = ReflectionUtil.getRawType(classType);
        int index = ArrayUtilRt.find(aClass.getTypeParameters(), variable);
        if (index >= 0) {
            return variable;
        }
        Class<?>[] classes = aClass.getInterfaces();
        Type[] genericInterfaces = aClass.getGenericInterfaces();
        for (int i = 0; i <= classes.length; ++i) {
            Type type;
            Class<?> anInterface;
            if (i < classes.length) {
                anInterface = classes[i];
            } else {
                anInterface = aClass.getSuperclass();
                if (resolveInInterfacesOnly || anInterface == null) continue;
            }
            Type resolved = ReflectionUtil.resolveVariable(variable, anInterface);
            if (resolved instanceof Class || resolved instanceof ParameterizedType) {
                return resolved;
            }
            if (!(resolved instanceof TypeVariable)) continue;
            TypeVariable typeVariable = (TypeVariable)resolved;
            index = ArrayUtilRt.find(anInterface.getTypeParameters(), typeVariable);
            assert (index >= 0) : "Cannot resolve type variable:\ntypeVariable = " + typeVariable + "\n" + "genericDeclaration = " + ReflectionUtil.declarationToString(typeVariable.getGenericDeclaration()) + "\n" + "searching in " + ReflectionUtil.declarationToString(anInterface);
            Type type2 = type = i < genericInterfaces.length ? genericInterfaces[i] : aClass.getGenericSuperclass();
            if (type instanceof Class) {
                return Object.class;
            }
            if (type instanceof ParameterizedType) {
                return ReflectionUtil.getActualTypeArguments((ParameterizedType)type)[index];
            }
            throw new AssertionError((Object)("Invalid type: " + type));
        }
        return null;
    }

    public static String declarationToString(GenericDeclaration anInterface) {
        return anInterface.toString() + Arrays.asList(anInterface.getTypeParameters()) + " loaded by " + ((Class)anInterface).getClassLoader();
    }

    public static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ReflectionUtil.getRawType(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            return Array.newInstance(ReflectionUtil.getRawType(((GenericArrayType)type).getGenericComponentType()), 0).getClass();
        }
        assert (false) : type;
        return null;
    }

    public static Type[] getActualTypeArguments(ParameterizedType parameterizedType) {
        return parameterizedType.getActualTypeArguments();
    }

    public static Class<?> substituteGenericType(Type genericType, Type classType) {
        if (genericType instanceof TypeVariable) {
            int index;
            Class<?> aClass = ReflectionUtil.getRawType(classType);
            Type type = ReflectionUtil.resolveVariable((TypeVariable)genericType, aClass);
            if (type instanceof Class) {
                return (Class)type;
            }
            if (type instanceof ParameterizedType) {
                return (Class)((ParameterizedType)type).getRawType();
            }
            if (type instanceof TypeVariable && classType instanceof ParameterizedType && (index = ArrayUtilRt.find(aClass.getTypeParameters(), type)) >= 0) {
                return ReflectionUtil.getRawType(ReflectionUtil.getActualTypeArguments((ParameterizedType)classType)[index]);
            }
        } else {
            return ReflectionUtil.getRawType(genericType);
        }
        return null;
    }

    public static List<Field> collectFields(Class clazz) {
        ArrayList<Field> result = new ArrayList<Field>();
        ReflectionUtil.collectFields(clazz, result);
        return result;
    }

    public static Field findField(Class clazz, Class type, String name) throws NoSuchFieldException {
        List<Field> fields = ReflectionUtil.collectFields(clazz);
        for (Field each : fields) {
            if (!name.equals(each.getName()) || type != null && !each.getType().equals(type)) continue;
            return each;
        }
        throw new NoSuchFieldException("Class: " + clazz + " name: " + name + " type: " + type);
    }

    public static Field findAssignableField(Class clazz, Class type, String name) throws NoSuchFieldException {
        List<Field> fields = ReflectionUtil.collectFields(clazz);
        for (Field each : fields) {
            if (!name.equals(each.getName()) || !type.isAssignableFrom(each.getType())) continue;
            return each;
        }
        throw new NoSuchFieldException("Class: " + clazz + " name: " + name + " type: " + type);
    }

    private static void collectFields(Class clazz, List<Field> result) {
        Class<?>[] interfaces;
        Field[] fields = clazz.getDeclaredFields();
        result.addAll(Arrays.asList(fields));
        Class superClass = clazz.getSuperclass();
        if (superClass != null) {
            ReflectionUtil.collectFields(superClass, result);
        }
        for (Class<?> each : interfaces = clazz.getInterfaces()) {
            ReflectionUtil.collectFields(each, result);
        }
    }

    public static void resetField(Class clazz, Class type, String name) {
        try {
            ReflectionUtil.resetField(null, ReflectionUtil.findField(clazz, type, name));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    public static void resetField(Object object, Class type, String name) {
        try {
            ReflectionUtil.resetField(object, ReflectionUtil.findField(object.getClass(), type, name));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    public static void resetField(Object object, String name) {
        try {
            ReflectionUtil.resetField(object, ReflectionUtil.findField(object.getClass(), null, name));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    public static void resetField(Object object, Field field) {
        field.setAccessible(true);
        Class<?> type = field.getType();
        try {
            if (type.isPrimitive()) {
                if (Boolean.TYPE.equals(type)) {
                    field.set(object, Boolean.FALSE);
                } else if (Integer.TYPE.equals(type)) {
                    field.set(object, new Integer(0));
                } else if (Double.TYPE.equals(type)) {
                    field.set(object, new Double(0.0));
                } else if (Float.TYPE.equals(type)) {
                    field.set(object, new Float(0.0f));
                }
            } else {
                field.set(object, null);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public static Method findMethod(Method[] methods, String name, Class ... parameters) {
        for (Method method : methods) {
            if (!name.equals(method.getName()) || !Arrays.equals(parameters, method.getParameterTypes())) continue;
            return method;
        }
        return null;
    }

    public static Method getMethod(Class aClass, String name, Class ... parameters) {
        return ReflectionUtil.findMethod(aClass.getMethods(), name, parameters);
    }

    public static Method getDeclaredMethod(Class aClass, String name, Class ... parameters) {
        return ReflectionUtil.findMethod(aClass.getDeclaredMethods(), name, parameters);
    }

    public static <T> T getField(Class objectClass, Object object, Class<T> type, String name) {
        try {
            Field field = ReflectionUtil.findAssignableField(objectClass, type, name);
            field.setAccessible(true);
            return (T)field.get(object);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public static Type resolveVariableInHierarchy(TypeVariable variable, Class aClass) {
        Type type;
        Class current = aClass;
        while ((type = ReflectionUtil.resolveVariable(variable, current, false)) == null) {
            if ((current = current.getSuperclass()) != null) continue;
            return null;
        }
        if (type instanceof TypeVariable) {
            return ReflectionUtil.resolveVariableInHierarchy((TypeVariable)type, aClass);
        }
        return type;
    }

    public static <T> Constructor<T> getDefaultConstructor(Class<T> aClass) {
        try {
            Constructor<T> constructor = aClass.getConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("No default constructor in " + aClass, e);
        }
    }

    public static <T> T createInstance(Constructor<T> constructor, Object ... args) {
        try {
            return constructor.newInstance(args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void resetThreadLocals() {
        try {
            Field field = Thread.class.getDeclaredField("threadLocals");
            field.setAccessible(true);
            field.set(Thread.currentThread(), null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static Class findCallerClass(int framesToSkip) {
        try {
            Class[] stack = MySecurityManager.INSTANCE.getStack();
            int indexFromTop = 1 + framesToSkip;
            return stack.length > indexFromTop ? stack[indexFromTop] : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static class MySecurityManager
    extends SecurityManager {
        private static final MySecurityManager INSTANCE = new MySecurityManager();

        private MySecurityManager() {
        }

        public Class[] getStack() {
            return this.getClassContext();
        }
    }
}

