/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.iconloader.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ConcurrencyUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<Future<T>> invokeAll(Collection<Callable<T>> tasks, ExecutorService executorService) throws Throwable {
        if (executorService == null) {
            for (Callable<T> task : tasks) {
                task.call();
            }
            return null;
        }
        ArrayList<Future<T>> futures = new ArrayList<Future<T>>(tasks.size());
        boolean done = false;
        try {
            for (Callable<T> callable : tasks) {
                Future<T> future = executorService.submit(callable);
                futures.add(future);
            }
            for (Future future : futures) {
                ((Runnable)((Object)future)).run();
            }
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (CancellationException ignore) {
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    if (cause == null) continue;
                    throw cause;
                }
            }
            done = true;
        }
        finally {
            if (!done) {
                for (Future future : futures) {
                    future.cancel(false);
                }
            }
        }
        return futures;
    }

    public static <K, V> V cacheOrGet(ConcurrentMap<K, V> map, K key, V defaultValue) {
        Object v = map.get(key);
        if (v != null) {
            return v;
        }
        V prev = map.putIfAbsent(key, defaultValue);
        return prev == null ? defaultValue : prev;
    }

    public static ThreadPoolExecutor newSingleThreadExecutor(String threadFactoryName) {
        return ConcurrencyUtil.newSingleThreadExecutor(threadFactoryName, 5);
    }

    public static ThreadPoolExecutor newSingleThreadExecutor(String threadFactoryName, int threadPriority) {
        return new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), ConcurrencyUtil.newNamedThreadFactory(threadFactoryName, true, threadPriority));
    }

    public static ScheduledThreadPoolExecutor newSingleScheduledThreadExecutor(String threadFactoryName) {
        return ConcurrencyUtil.newSingleScheduledThreadExecutor(threadFactoryName, 5);
    }

    public static ScheduledThreadPoolExecutor newSingleScheduledThreadExecutor(String threadFactoryName, int threadPriority) {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, ConcurrencyUtil.newNamedThreadFactory(threadFactoryName, true, threadPriority));
        executor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        return executor;
    }

    public static ThreadFactory newNamedThreadFactory(final String threadName, final boolean isDaemon, final int threadPriority) {
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, threadName);
                thread.setDaemon(isDaemon);
                thread.setPriority(threadPriority);
                return thread;
            }
        };
    }

    public static ThreadFactory newNamedThreadFactory(final String threadName) {
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, threadName);
            }
        };
    }
}

