/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import ar.com.hjg.pngj.PngjOutputException;
import ar.com.hjg.pngj.chunks.ChunkHelper;
import ar.com.hjg.pngj.chunks.ChunkRaw;
import java.io.OutputStream;

public class IDatChunkWriter {
    private static final int MAX_LEN_DEFAULT = 32768;
    private final OutputStream outputStream;
    private final int maxChunkLen;
    private byte[] buf;
    private int offset = 0;
    private int availLen;
    private long totalBytesWriten = 0L;
    private int chunksWriten = 0;

    public IDatChunkWriter(OutputStream outputStream) {
        this(outputStream, 0);
    }

    public IDatChunkWriter(OutputStream outputStream, int maxChunkLength) {
        this.outputStream = outputStream;
        this.maxChunkLen = maxChunkLength > 0 ? maxChunkLength : 32768;
        this.buf = new byte[this.maxChunkLen];
        this.availLen = this.maxChunkLen - this.offset;
        this.postReset();
    }

    public IDatChunkWriter(OutputStream outputStream, byte[] b) {
        this.outputStream = outputStream;
        this.buf = b != null ? b : new byte[32768];
        this.maxChunkLen = b.length;
        this.availLen = this.maxChunkLen - this.offset;
        this.postReset();
    }

    protected byte[] getChunkId() {
        return ChunkHelper.b_IDAT;
    }

    public final void flush() {
        if (this.offset > 0 && this.offset >= this.minLenToWrite()) {
            ChunkRaw c = new ChunkRaw(this.offset, this.getChunkId(), false);
            c.data = this.buf;
            c.writeChunk(this.outputStream);
            this.totalBytesWriten += (long)(c.len + 12);
            ++this.chunksWriten;
            this.offset = 0;
            this.availLen = this.maxChunkLen;
            this.postReset();
        }
    }

    public int getOffset() {
        return this.offset;
    }

    public int getAvailLen() {
        return this.availLen;
    }

    public void incrementOffset(int n) {
        this.offset += n;
        this.availLen -= n;
        if (this.availLen < 0) {
            throw new PngjOutputException("Anomalous situation");
        }
        if (this.availLen == 0) {
            this.flush();
        }
    }

    public void write(byte[] b, int o, int len) {
        while (len > 0) {
            int n = len <= this.availLen ? len : this.availLen;
            System.arraycopy(b, o, this.buf, this.offset, n);
            this.incrementOffset(n);
            len -= n;
            o += n;
        }
    }

    protected void postReset() {
    }

    protected int minLenToWrite() {
        return 1;
    }

    public void close() {
        this.flush();
        this.offset = 0;
        this.buf = null;
    }

    public byte[] getBuf() {
        return this.buf;
    }

    public long getTotalBytesWriten() {
        return this.totalBytesWriten;
    }

    public int getChunksWriten() {
        return this.chunksWriten;
    }
}

